/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.dynamodb.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * TableDescription JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class TableDescriptionUnmarshaller implements Unmarshaller<TableDescription, JsonUnmarshallerContext> {

    public TableDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        TableDescription.Builder tableDescriptionBuilder = TableDescription.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("AttributeDefinitions", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.attributeDefinitions(new ListUnmarshaller<AttributeDefinition>(
                            AttributeDefinitionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.tableName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("KeySchema", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.keySchema(new ListUnmarshaller<KeySchemaElement>(KeySchemaElementUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("TableStatus", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.tableStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationDateTime", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder
                            .creationDateTime(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("ProvisionedThroughput", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.provisionedThroughput(ProvisionedThroughputDescriptionUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("TableSizeBytes", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.tableSizeBytes(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("ItemCount", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.itemCount(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("TableArn", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.tableArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LocalSecondaryIndexes", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.localSecondaryIndexes(new ListUnmarshaller<LocalSecondaryIndexDescription>(
                            LocalSecondaryIndexDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("GlobalSecondaryIndexes", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.globalSecondaryIndexes(new ListUnmarshaller<GlobalSecondaryIndexDescription>(
                            GlobalSecondaryIndexDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("StreamSpecification", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder
                            .streamSpecification(StreamSpecificationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LatestStreamLabel", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.latestStreamLabel(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LatestStreamArn", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.latestStreamArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return tableDescriptionBuilder.build();
    }

    private static final TableDescriptionUnmarshaller INSTANCE = new TableDescriptionUnmarshaller();

    public static TableDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
