/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Map;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.dynamodb.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * QueryResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class QueryResponseUnmarshaller implements Unmarshaller<QueryResponse, JsonUnmarshallerContext> {

    public QueryResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        QueryResponse.Builder queryResponseBuilder = QueryResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return queryResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Items", targetDepth)) {
                    context.nextToken();
                    queryResponseBuilder.items(new ListUnmarshaller<java.util.Map<String, AttributeValue>>(
                            new MapUnmarshaller<String, AttributeValue>(context.getUnmarshaller(String.class),
                                    AttributeValueUnmarshaller.getInstance())).unmarshall(context));
                }
                if (context.testExpression("Count", targetDepth)) {
                    context.nextToken();
                    queryResponseBuilder.count(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("ScannedCount", targetDepth)) {
                    context.nextToken();
                    queryResponseBuilder.scannedCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("LastEvaluatedKey", targetDepth)) {
                    context.nextToken();
                    queryResponseBuilder.lastEvaluatedKey(new MapUnmarshaller<String, AttributeValue>(context
                            .getUnmarshaller(String.class), AttributeValueUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ConsumedCapacity", targetDepth)) {
                    context.nextToken();
                    queryResponseBuilder.consumedCapacity(ConsumedCapacityUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return queryResponseBuilder.build();
    }

    private static final QueryResponseUnmarshaller INSTANCE = new QueryResponseUnmarshaller();

    public static QueryResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
