/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ConsumedCapacity} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ConsumedCapacityMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();

    private static final MarshallingInfo<Double> CAPACITYUNITS_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CapacityUnits").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> TABLE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Table").isBinary(false).build();

    private static final MarshallingInfo<Map> LOCALSECONDARYINDEXES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalSecondaryIndexes").isBinary(false).build();

    private static final MarshallingInfo<Map> GLOBALSECONDARYINDEXES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalSecondaryIndexes").isBinary(false).build();

    private static final ConsumedCapacityMarshaller INSTANCE = new ConsumedCapacityMarshaller();

    private ConsumedCapacityMarshaller() {
    }

    public static ConsumedCapacityMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ConsumedCapacity consumedCapacity, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(consumedCapacity, "consumedCapacity");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(consumedCapacity.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(consumedCapacity.capacityUnits(), CAPACITYUNITS_BINDING);
            protocolMarshaller.marshall(consumedCapacity.table(), TABLE_BINDING);
            protocolMarshaller.marshall(consumedCapacity.localSecondaryIndexes(), LOCALSECONDARYINDEXES_BINDING);
            protocolMarshaller.marshall(consumedCapacity.globalSecondaryIndexes(), GLOBALSECONDARYINDEXES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
