/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.dynamodb.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * BatchWriteItemResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class BatchWriteItemResponseUnmarshaller implements Unmarshaller<BatchWriteItemResponse, JsonUnmarshallerContext> {

    public BatchWriteItemResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        BatchWriteItemResponse.Builder batchWriteItemResponseBuilder = BatchWriteItemResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return batchWriteItemResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("UnprocessedItems", targetDepth)) {
                    context.nextToken();
                    batchWriteItemResponseBuilder.unprocessedItems(new MapUnmarshaller<String, java.util.List<WriteRequest>>(
                            context.getUnmarshaller(String.class), new ListUnmarshaller<WriteRequest>(WriteRequestUnmarshaller
                                    .getInstance())).unmarshall(context));
                }
                if (context.testExpression("ItemCollectionMetrics", targetDepth)) {
                    context.nextToken();
                    batchWriteItemResponseBuilder
                            .itemCollectionMetrics(new MapUnmarshaller<String, java.util.List<ItemCollectionMetrics>>(context
                                    .getUnmarshaller(String.class), new ListUnmarshaller<ItemCollectionMetrics>(
                                    ItemCollectionMetricsUnmarshaller.getInstance())).unmarshall(context));
                }
                if (context.testExpression("ConsumedCapacity", targetDepth)) {
                    context.nextToken();
                    batchWriteItemResponseBuilder.consumedCapacity(new ListUnmarshaller<ConsumedCapacity>(
                            ConsumedCapacityUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return batchWriteItemResponseBuilder.build();
    }

    private static final BatchWriteItemResponseUnmarshaller INSTANCE = new BatchWriteItemResponseUnmarshaller();

    public static BatchWriteItemResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
