/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The operation attempted to read past the oldest stream record in a shard.
 * </p>
 * <p>
 * In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records whose age exceeds this limit are
 * subject to removal (trimming) from the stream. You might receive a TrimmedDataAccessException if:
 * </p>
 * <ul>
 * <li>
 * <p>
 * You request a shard iterator with a sequence number older than the trim point (24 hours).
 * </p>
 * </li>
 * <li>
 * <p>
 * You obtain a shard iterator, but before you use the iterator in a <code>GetRecords</code> request, a stream record in
 * the shard exceeds the 24 hour period and is trimmed. This causes the iterator to access a record that no longer
 * exists.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public class TrimmedDataAccessException extends DynamoDBException implements
        ToCopyableBuilder<TrimmedDataAccessException.Builder, TrimmedDataAccessException> {
    private TrimmedDataAccessException(BuilderImpl builder) {
        super(builder.message);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public interface Builder extends CopyableBuilder<Builder, TrimmedDataAccessException> {
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(TrimmedDataAccessException model) {
            this.message = model.getMessage();
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public TrimmedDataAccessException build() {
            return new TrimmedDataAccessException(this);
        }
    }
}
