/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.DeleteRequestMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to perform a <code>DeleteItem</code> operation on an item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteRequest implements StructuredPojo, ToCopyableBuilder<DeleteRequest.Builder, DeleteRequest> {
    private final Map<String, AttributeValue> key;

    private DeleteRequest(BuilderImpl builder) {
        this.key = builder.key;
    }

    /**
     * <p>
     * A map of attribute name to attribute values, representing the primary key of the item to delete. All of the
     * table's primary key attributes must be specified, and their data types must match those of the table's key
     * schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of attribute name to attribute values, representing the primary key of the item to delete. All of
     *         the table's primary key attributes must be specified, and their data types must match those of the
     *         table's key schema.
     */
    public Map<String, AttributeValue> key() {
        return key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRequest)) {
            return false;
        }
        DeleteRequest other = (DeleteRequest) obj;
        return Objects.equals(key(), other.key());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteRequest").add("Key", key()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.of(clazz.cast(key()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeleteRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteRequest> {
        /**
         * <p>
         * A map of attribute name to attribute values, representing the primary key of the item to delete. All of the
         * table's primary key attributes must be specified, and their data types must match those of the table's key
         * schema.
         * </p>
         * 
         * @param key
         *        A map of attribute name to attribute values, representing the primary key of the item to delete. All
         *        of the table's primary key attributes must be specified, and their data types must match those of the
         *        table's key schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(Map<String, AttributeValue> key);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, AttributeValue> key;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRequest model) {
            key(model.key);
        }

        public final Map<String, AttributeValue.Builder> getKey() {
            return key != null ? CollectionUtils.mapValues(key, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final void setKey(Map<String, AttributeValue.BuilderImpl> key) {
            this.key = KeyCopier.copyFromBuilder(key);
        }

        @Override
        public DeleteRequest build() {
            return new DeleteRequest(this);
        }
    }
}
