/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.BatchableReadOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;

@SdkPublicApi
public class ReadBatch<T> {
    private final MappedTable<T> mappedTable;
    private final Collection<BatchableReadOperation> readOperations;

    private ReadBatch(MappedTable<T> mappedTable, Collection<BatchableReadOperation> readOperations) {
        this.mappedTable = mappedTable;
        this.readOperations = readOperations;
    }

    public static <T> ReadBatch<T> of(MappedTable<T> mappedTable, Collection<BatchableReadOperation> readOperations) {
        return new ReadBatch<T>(mappedTable, readOperations);
    }

    public static <T> ReadBatch<T> of(MappedTable<T> mappedTable, BatchableReadOperation ... readOperations) {
        return new ReadBatch<T>(mappedTable, Arrays.asList(readOperations));
    }

    void addReadRequestsToMap(Map<String, KeysAndAttributes> readRequestMap) {
        KeysAndAttributes newKeysAndAttributes = this.generateKeysAndAttributes();
        KeysAndAttributes existingKeysAndAttributes = readRequestMap.get(this.getTableName());
        if (existingKeysAndAttributes == null) {
            readRequestMap.put(this.getTableName(), newKeysAndAttributes);
            return;
        }
        KeysAndAttributes mergedKeysAndAttributes = ReadBatch.mergeKeysAndAttributes(existingKeysAndAttributes, newKeysAndAttributes);
        readRequestMap.put(this.getTableName(), mergedKeysAndAttributes);
    }

    String getTableName() {
        return this.mappedTable.getTableName();
    }

    private KeysAndAttributes generateKeysAndAttributes() {
        AtomicReference consistentRead = new AtomicReference();
        AtomicBoolean firstRecord = new AtomicBoolean(true);
        List keys = this.readOperations.stream().peek(operation -> {
            if (firstRecord.getAndSet(false)) {
                consistentRead.set(operation.getConsistentRead());
            } else if (!ReadBatch.compareNullableBooleans((Boolean)consistentRead.get(), operation.getConsistentRead())) {
                throw new IllegalArgumentException("All batchable read requests for the same table must have the same 'consistentRead' setting.");
            }
        }).map(BatchableReadOperation::getKey).map(key -> key.getKeyMap(this.mappedTable.getTableSchema(), TableMetadata.getPrimaryIndexName())).collect(Collectors.toList());
        return (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).consistentRead((Boolean)consistentRead.get()).build();
    }

    public MappedTable<T> getMappedTable() {
        return this.mappedTable;
    }

    public Collection<BatchableReadOperation> getReadOperations() {
        return this.readOperations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadBatch readBatch = (ReadBatch)o;
        if (this.mappedTable != null ? !this.mappedTable.equals(readBatch.mappedTable) : readBatch.mappedTable != null) {
            return false;
        }
        return this.readOperations != null ? this.readOperations.equals(readBatch.readOperations) : readBatch.readOperations == null;
    }

    public int hashCode() {
        int result = this.mappedTable != null ? this.mappedTable.hashCode() : 0;
        result = 31 * result + (this.readOperations != null ? this.readOperations.hashCode() : 0);
        return result;
    }

    private static boolean compareNullableBooleans(Boolean one, Boolean two) {
        if (one == null && two == null) {
            return true;
        }
        if (one != null) {
            return one.equals(two);
        }
        return false;
    }

    private static KeysAndAttributes mergeKeysAndAttributes(KeysAndAttributes first, KeysAndAttributes second) {
        if (!ReadBatch.compareNullableBooleans(first.consistentRead(), second.consistentRead())) {
            throw new IllegalArgumentException("All batchable read requests for the same table must have the same 'consistentRead' setting.");
        }
        Boolean consistentRead = first.consistentRead() == null ? second.consistentRead() : first.consistentRead();
        List keys = Stream.concat(first.keys().stream(), second.keys().stream()).collect(Collectors.toList());
        return (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).consistentRead(consistentRead).build();
    }
}

