/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.AttributeType;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.StaticAttributeType;
import software.amazon.awssdk.enhanced.dynamodb.mapper.ImmutableAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableMetadata;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public final class ResolvedImmutableAttribute<T, B> {
    private final String attributeName;
    private final Function<T, AttributeValue> getAttributeMethod;
    private final BiConsumer<B, AttributeValue> updateBuilderMethod;
    private final StaticTableMetadata tableMetadata;
    private final AttributeConverter attributeConverter;

    private ResolvedImmutableAttribute(String attributeName, Function<T, AttributeValue> getAttributeMethod, BiConsumer<B, AttributeValue> updateBuilderMethod, StaticTableMetadata tableMetadata, AttributeConverter attributeConverter) {
        this.attributeName = attributeName;
        this.getAttributeMethod = getAttributeMethod;
        this.updateBuilderMethod = updateBuilderMethod;
        this.tableMetadata = tableMetadata;
        this.attributeConverter = attributeConverter;
    }

    public static <T, B, R> ResolvedImmutableAttribute<T, B> create(ImmutableAttribute<T, B, R> immutableAttribute, AttributeConverter<R> attributeConverter) {
        AttributeType attributeType = StaticAttributeType.create(attributeConverter);
        Function<Object, AttributeValue> getAttributeValueWithTransform = item -> {
            Object value = immutableAttribute.getter().apply(item);
            return value == null ? AttributeValues.nullAttributeValue() : attributeType.objectToAttributeValue(value);
        };
        BiConsumer<Object, AttributeValue> updateBuilderWithTransform = (builder, attributeValue) -> {
            if (EnhancedClientUtils.isNullAttributeValue(attributeValue)) {
                return;
            }
            Object value = attributeType.attributeValueToObject((AttributeValue)attributeValue);
            if (value != null) {
                immutableAttribute.setter().accept(builder, value);
            }
        };
        StaticTableMetadata.Builder tableMetadataBuilder = StaticTableMetadata.builder();
        immutableAttribute.tags().forEach(tag -> {
            tag.validateType(immutableAttribute.name(), immutableAttribute.type(), attributeType.attributeValueType());
            tag.modifyMetadata(immutableAttribute.name(), attributeType.attributeValueType()).accept(tableMetadataBuilder);
        });
        return new ResolvedImmutableAttribute<Object, Object>(immutableAttribute.name(), getAttributeValueWithTransform, updateBuilderWithTransform, tableMetadataBuilder.build(), attributeConverter);
    }

    public <T1, B1> ResolvedImmutableAttribute<T1, B1> transform(Function<T1, T> transformItem, Function<B1, B> transformBuilder) {
        return new ResolvedImmutableAttribute<Object, Object>(this.attributeName, item -> {
            Object otherItem = transformItem.apply(item);
            return otherItem == null ? AttributeValues.nullAttributeValue() : this.getAttributeMethod.apply(otherItem);
        }, (item, value) -> this.updateBuilderMethod.accept((B)transformBuilder.apply(item), (AttributeValue)value), this.tableMetadata, this.attributeConverter);
    }

    public String attributeName() {
        return this.attributeName;
    }

    public Function<T, AttributeValue> attributeGetterMethod() {
        return this.getAttributeMethod;
    }

    public BiConsumer<B, AttributeValue> updateItemMethod() {
        return this.updateBuilderMethod;
    }

    public StaticTableMetadata tableMetadata() {
        return this.tableMetadata;
    }

    public AttributeConverter attributeConverter() {
        return this.attributeConverter;
    }
}

