/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import java.util.Optional;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.IndexMetadata;
import software.amazon.awssdk.enhanced.dynamodb.KeyAttributeMetadata;

@SdkInternalApi
public class StaticIndexMetadata
implements IndexMetadata {
    private final String name;
    private final KeyAttributeMetadata partitionKey;
    private final KeyAttributeMetadata sortKey;

    private StaticIndexMetadata(Builder b) {
        this.name = b.name;
        this.partitionKey = b.partitionKey;
        this.sortKey = b.sortKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(IndexMetadata index) {
        return index == null ? StaticIndexMetadata.builder() : StaticIndexMetadata.builder().name(index.name()).partitionKey(index.partitionKey().orElse(null)).sortKey(index.sortKey().orElse(null));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Optional<KeyAttributeMetadata> partitionKey() {
        return Optional.ofNullable(this.partitionKey);
    }

    @Override
    public Optional<KeyAttributeMetadata> sortKey() {
        return Optional.ofNullable(this.sortKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticIndexMetadata that = (StaticIndexMetadata)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.partitionKey != null ? !this.partitionKey.equals(that.partitionKey) : that.partitionKey != null) {
            return false;
        }
        return this.sortKey != null ? this.sortKey.equals(that.sortKey) : that.sortKey == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.partitionKey != null ? this.partitionKey.hashCode() : 0);
        result = 31 * result + (this.sortKey != null ? this.sortKey.hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static class Builder {
        private String name;
        private KeyAttributeMetadata partitionKey;
        private KeyAttributeMetadata sortKey;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder partitionKey(KeyAttributeMetadata partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Builder sortKey(KeyAttributeMetadata sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        public StaticIndexMetadata build() {
            return new StaticIndexMetadata(this);
        }
    }
}

