/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.NestedAttributeName;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public class ProjectionExpression {
    private static final String AMZN_MAPPED = "#AMZN_MAPPED_";
    private static final UnaryOperator<String> PROJECTION_EXPRESSION_KEY_MAPPER = k -> AMZN_MAPPED + EnhancedClientUtils.cleanAttributeName(k);
    private final Optional<String> projectionExpressionAsString;
    private final Map<String, String> expressionAttributeNames;

    private ProjectionExpression(List<NestedAttributeName> nestedAttributeNames) {
        this.expressionAttributeNames = ProjectionExpression.createAttributePlaceholders(nestedAttributeNames);
        this.projectionExpressionAsString = ProjectionExpression.buildProjectionExpression(nestedAttributeNames, this.expressionAttributeNames);
    }

    public static ProjectionExpression create(List<NestedAttributeName> nestedAttributeNames) {
        return new ProjectionExpression(nestedAttributeNames);
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public Optional<String> projectionExpressionAsString() {
        return this.projectionExpressionAsString;
    }

    private static Map<String, String> createAttributePlaceholders(List<NestedAttributeName> nestedAttributeNames) {
        if (CollectionUtils.isNullOrEmpty(nestedAttributeNames)) {
            return new HashMap<String, String>();
        }
        Map placeholderToAttributeNames = nestedAttributeNames.stream().flatMap(n -> n.elements().stream()).distinct().collect(Collectors.groupingBy(PROJECTION_EXPRESSION_KEY_MAPPER, Collectors.toList()));
        return Collections.unmodifiableMap(placeholderToAttributeNames.entrySet().stream().flatMap(entry -> ProjectionExpression.disambiguateNonUniquePlaceholderNames((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toMap(Pair::left, Pair::right)));
    }

    private static Stream<Pair<String, String>> disambiguateNonUniquePlaceholderNames(String placeholder, List<String> values) {
        if (values.size() == 1) {
            return Stream.of(Pair.of((Object)placeholder, (Object)values.get(0)));
        }
        return IntStream.range(0, values.size()).mapToObj(index -> Pair.of((Object)ProjectionExpression.addDisambiguator(placeholder, index), (Object)((String)values.get(index))));
    }

    private static String addDisambiguator(String placeholder, int index) {
        return AMZN_MAPPED + index + "_" + placeholder.substring(AMZN_MAPPED.length());
    }

    private static Optional<String> buildProjectionExpression(List<NestedAttributeName> nestedAttributeNames, Map<String, String> expressionAttributeNames) {
        if (CollectionUtils.isNullOrEmpty(nestedAttributeNames)) {
            return Optional.empty();
        }
        Map attributeToPlaceholderNames = CollectionUtils.inverseMap(expressionAttributeNames);
        return Optional.of(nestedAttributeNames.stream().map(attributeName -> ProjectionExpression.convertToNameExpression(attributeName, attributeToPlaceholderNames)).distinct().collect(Collectors.joining(",")));
    }

    private static String convertToNameExpression(NestedAttributeName nestedAttributeName, Map<String, String> attributeToSanitizedMap) {
        return nestedAttributeName.elements().stream().map(attributeToSanitizedMap::get).collect(Collectors.joining("."));
    }
}

