/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.document;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkNumber;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.document.EnhancedDocument;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.ChainConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.JsonItemAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.ListAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.MapAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.document.JsonStringFormatHelper;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

@Immutable
@SdkInternalApi
public class DefaultEnhancedDocument
implements EnhancedDocument {
    private static final Lazy<IllegalStateException> NULL_SET_ERROR = new Lazy(() -> new IllegalStateException("Set must not have null values."));
    private static final JsonItemAttributeConverter JSON_ATTRIBUTE_CONVERTER = JsonItemAttributeConverter.create();
    private static final String VALIDATE_TYPE_ERROR = "Values of type %s are not supported by this API, please use the %s%s API instead";
    private static final AttributeValue NULL_ATTRIBUTE_VALUE = AttributeValue.fromNul((Boolean)true);
    private final Map<String, Object> nonAttributeValueMap;
    private final Map<String, EnhancedType> enhancedTypeMap;
    private final List<AttributeConverterProvider> attributeConverterProviders;
    private final ChainConverterProvider attributeConverterChain;
    private final Lazy<Map<String, AttributeValue>> attributeValueMap = new Lazy(this::initializeAttributeValueMap);

    public DefaultEnhancedDocument(DefaultBuilder builder) {
        this.nonAttributeValueMap = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(builder.nonAttributeValueMap));
        this.attributeConverterProviders = Collections.unmodifiableList(new ArrayList<AttributeConverterProvider>(builder.attributeConverterProviders));
        this.attributeConverterChain = ChainConverterProvider.create(this.attributeConverterProviders);
        this.enhancedTypeMap = Collections.unmodifiableMap(builder.enhancedTypeMap);
    }

    public static EnhancedDocument.Builder builder() {
        return new DefaultBuilder();
    }

    public static <T> AttributeConverter<T> converterForClass(EnhancedType<T> type, ChainConverterProvider chainConverterProvider) {
        if (type.rawClass().isAssignableFrom(List.class)) {
            return ListAttributeConverter.create(DefaultEnhancedDocument.converterForClass(type.rawClassParameters().get(0), chainConverterProvider));
        }
        if (type.rawClass().isAssignableFrom(Map.class)) {
            return MapAttributeConverter.mapConverter(StringConverterProvider.defaultProvider().converterFor(type.rawClassParameters().get(0)), DefaultEnhancedDocument.converterForClass(type.rawClassParameters().get(1), chainConverterProvider));
        }
        return Optional.ofNullable(chainConverterProvider.converterFor(type)).orElseThrow(() -> new IllegalStateException("AttributeConverter not found for class " + type + ". Please add an AttributeConverterProvider for this type. If it is a default type, add the DefaultAttributeConverterProvider to the builder."));
    }

    @Override
    public EnhancedDocument.Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    @Override
    public List<AttributeConverterProvider> attributeConverterProviders() {
        return this.attributeConverterProviders;
    }

    @Override
    public boolean isNull(String attributeName) {
        if (!this.isPresent(attributeName)) {
            return false;
        }
        Object attributeValue = this.nonAttributeValueMap.get(attributeName);
        return attributeValue == null || NULL_ATTRIBUTE_VALUE.equals(attributeValue);
    }

    @Override
    public boolean isPresent(String attributeName) {
        return this.nonAttributeValueMap.containsKey(attributeName);
    }

    @Override
    public <T> T get(String attributeName, EnhancedType<T> type) {
        AttributeValue attributeValue = (AttributeValue)((Map)this.attributeValueMap.getValue()).get(attributeName);
        if (attributeValue == null) {
            return null;
        }
        return this.fromAttributeValue(attributeValue, type);
    }

    @Override
    public String getString(String attributeName) {
        return this.get(attributeName, String.class);
    }

    @Override
    public SdkNumber getNumber(String attributeName) {
        return this.get(attributeName, SdkNumber.class);
    }

    @Override
    public <T> T get(String attributeName, Class<T> clazz) {
        DefaultEnhancedDocument.checkAndValidateClass(clazz, false);
        return this.get(attributeName, EnhancedType.of(clazz));
    }

    @Override
    public SdkBytes getBytes(String attributeName) {
        return this.get(attributeName, SdkBytes.class);
    }

    @Override
    public Set<String> getStringSet(String attributeName) {
        return this.get(attributeName, EnhancedType.setOf(String.class));
    }

    @Override
    public Set<SdkNumber> getNumberSet(String attributeName) {
        return this.get(attributeName, EnhancedType.setOf(SdkNumber.class));
    }

    @Override
    public Set<SdkBytes> getBytesSet(String attributeName) {
        return this.get(attributeName, EnhancedType.setOf(SdkBytes.class));
    }

    @Override
    public <T> List<T> getList(String attributeName, EnhancedType<T> type) {
        return this.get(attributeName, EnhancedType.listOf(type));
    }

    @Override
    public <K, V> Map<K, V> getMap(String attributeName, EnhancedType<K> keyType, EnhancedType<V> valueType) {
        return this.get(attributeName, EnhancedType.mapOf(keyType, valueType));
    }

    @Override
    public String getJson(String attributeName) {
        AttributeValue attributeValue = (AttributeValue)((Map)this.attributeValueMap.getValue()).get(attributeName);
        if (attributeValue == null) {
            return null;
        }
        return JsonStringFormatHelper.stringValue(JSON_ATTRIBUTE_CONVERTER.transformTo(attributeValue));
    }

    @Override
    public Boolean getBoolean(String attributeName) {
        return this.get(attributeName, Boolean.class);
    }

    @Override
    public List<AttributeValue> getListOfUnknownType(String attributeName) {
        AttributeValue attributeValue = (AttributeValue)((Map)this.attributeValueMap.getValue()).get(attributeName);
        if (attributeValue == null) {
            return null;
        }
        if (!attributeValue.hasL()) {
            throw new IllegalStateException("Cannot get a List from attribute value of Type " + attributeValue.type());
        }
        return attributeValue.l();
    }

    @Override
    public Map<String, AttributeValue> getMapOfUnknownType(String attributeName) {
        AttributeValue attributeValue = (AttributeValue)((Map)this.attributeValueMap.getValue()).get(attributeName);
        if (attributeValue == null) {
            return null;
        }
        if (!attributeValue.hasM()) {
            throw new IllegalStateException("Cannot get a Map from attribute value of Type " + attributeValue.type());
        }
        return attributeValue.m();
    }

    @Override
    public String toJson() {
        if (this.nonAttributeValueMap.isEmpty()) {
            return "{}";
        }
        return ((Map)this.attributeValueMap.getValue()).entrySet().stream().map(entry -> "\"" + JsonStringFormatHelper.addEscapeCharacters((String)entry.getKey()) + "\":" + JsonStringFormatHelper.stringValue(JSON_ATTRIBUTE_CONVERTER.transformTo((AttributeValue)entry.getValue()))).collect(Collectors.joining(",", "{", "}"));
    }

    @Override
    public Map<String, AttributeValue> toMap() {
        return (Map)this.attributeValueMap.getValue();
    }

    private Map<String, AttributeValue> initializeAttributeValueMap() {
        LinkedHashMap<String, AttributeValue> result = new LinkedHashMap<String, AttributeValue>(this.nonAttributeValueMap.size());
        this.nonAttributeValueMap.forEach((k, v) -> {
            if (v == null) {
                result.put((String)k, NULL_ATTRIBUTE_VALUE);
            } else {
                result.put((String)k, this.toAttributeValue(v, this.enhancedTypeMap.getOrDefault(k, EnhancedType.of(v.getClass()))));
            }
        });
        return result;
    }

    private <T> AttributeValue toAttributeValue(T value, EnhancedType<T> enhancedType) {
        if (value instanceof AttributeValue) {
            return (AttributeValue)value;
        }
        return DefaultEnhancedDocument.converterForClass(enhancedType, this.attributeConverterChain).transformFrom(value);
    }

    private <T> T fromAttributeValue(AttributeValue attributeValue, EnhancedType<T> type) {
        if (type.rawClass().equals(AttributeValue.class)) {
            return (T)attributeValue;
        }
        return DefaultEnhancedDocument.converterForClass(type, this.attributeConverterChain).transformTo(attributeValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEnhancedDocument that = (DefaultEnhancedDocument)o;
        return this.nonAttributeValueMap.equals(that.nonAttributeValueMap) && Objects.equals(this.enhancedTypeMap, that.enhancedTypeMap) && Objects.equals(this.attributeValueMap, that.attributeValueMap) && Objects.equals(this.attributeConverterProviders, that.attributeConverterProviders) && this.attributeConverterChain.equals(that.attributeConverterChain);
    }

    public int hashCode() {
        int result = this.nonAttributeValueMap != null ? this.nonAttributeValueMap.hashCode() : 0;
        result = 31 * result + (this.attributeConverterProviders != null ? this.attributeConverterProviders.hashCode() : 0);
        return result;
    }

    private static void checkAndValidateClass(Class<?> type, boolean isPut) {
        Validate.paramNotNull(type, (String)"type");
        Validate.isTrue((!type.isAssignableFrom(List.class) ? 1 : 0) != 0, (String)String.format(VALIDATE_TYPE_ERROR, "List", isPut ? "put" : "get", "List"), (Object[])new Object[0]);
        Validate.isTrue((!type.isAssignableFrom(Map.class) ? 1 : 0) != 0, (String)String.format(VALIDATE_TYPE_ERROR, "Map", isPut ? "put" : "get", "Map"), (Object[])new Object[0]);
    }

    public static class DefaultBuilder
    implements EnhancedDocument.Builder {
        Map<String, Object> nonAttributeValueMap = new LinkedHashMap<String, Object>();
        Map<String, EnhancedType> enhancedTypeMap = new HashMap<String, EnhancedType>();
        List<AttributeConverterProvider> attributeConverterProviders = new ArrayList<AttributeConverterProvider>();

        private DefaultBuilder() {
        }

        public DefaultBuilder(DefaultEnhancedDocument enhancedDocument) {
            this.nonAttributeValueMap = new LinkedHashMap<String, Object>(enhancedDocument.nonAttributeValueMap);
            this.attributeConverterProviders = new ArrayList<AttributeConverterProvider>(enhancedDocument.attributeConverterProviders);
            this.enhancedTypeMap = new HashMap<String, EnhancedType>(enhancedDocument.enhancedTypeMap);
        }

        public EnhancedDocument.Builder putObject(String attributeName, Object value) {
            this.putObject(attributeName, value, false);
            return this;
        }

        private EnhancedDocument.Builder putObject(String attributeName, Object value, boolean ignoreNullValue) {
            if (!ignoreNullValue) {
                DefaultBuilder.checkInvalidAttribute(attributeName, value);
            } else {
                DefaultBuilder.validateAttributeName(attributeName);
            }
            this.enhancedTypeMap.remove(attributeName);
            this.nonAttributeValueMap.remove(attributeName);
            this.nonAttributeValueMap.put(attributeName, value);
            return this;
        }

        @Override
        public EnhancedDocument.Builder putString(String attributeName, String value) {
            return this.putObject(attributeName, value);
        }

        @Override
        public EnhancedDocument.Builder putNumber(String attributeName, Number value) {
            return this.putObject(attributeName, value);
        }

        @Override
        public EnhancedDocument.Builder putBytes(String attributeName, SdkBytes value) {
            return this.putObject(attributeName, value);
        }

        @Override
        public EnhancedDocument.Builder putBoolean(String attributeName, boolean value) {
            return this.putObject(attributeName, value);
        }

        @Override
        public EnhancedDocument.Builder putNull(String attributeName) {
            return this.putObject(attributeName, null, true);
        }

        @Override
        public EnhancedDocument.Builder putStringSet(String attributeName, Set<String> values) {
            DefaultBuilder.checkInvalidAttribute(attributeName, values);
            if (values.stream().anyMatch(Objects::isNull)) {
                throw (IllegalStateException)NULL_SET_ERROR.getValue();
            }
            return this.put(attributeName, values, EnhancedType.setOf(String.class));
        }

        @Override
        public EnhancedDocument.Builder putNumberSet(String attributeName, Set<Number> values) {
            DefaultBuilder.checkInvalidAttribute(attributeName, values);
            Set sdkNumberSet = values.stream().map(number -> {
                if (number == null) {
                    throw (IllegalStateException)NULL_SET_ERROR.getValue();
                }
                return SdkNumber.fromString((String)number.toString());
            }).collect(Collectors.toCollection(LinkedHashSet::new));
            return this.put(attributeName, sdkNumberSet, EnhancedType.setOf(SdkNumber.class));
        }

        @Override
        public EnhancedDocument.Builder putBytesSet(String attributeName, Set<SdkBytes> values) {
            DefaultBuilder.checkInvalidAttribute(attributeName, values);
            if (values.stream().anyMatch(Objects::isNull)) {
                throw (IllegalStateException)NULL_SET_ERROR.getValue();
            }
            return this.put(attributeName, values, EnhancedType.setOf(SdkBytes.class));
        }

        @Override
        public <T> EnhancedDocument.Builder putList(String attributeName, List<T> value, EnhancedType<T> type) {
            DefaultBuilder.checkInvalidAttribute(attributeName, value);
            Validate.paramNotNull(type, (String)"type");
            return this.put(attributeName, value, EnhancedType.listOf(type));
        }

        @Override
        public <T> EnhancedDocument.Builder put(String attributeName, T value, EnhancedType<T> type) {
            DefaultBuilder.checkInvalidAttribute(attributeName, value);
            Validate.notNull((Object)attributeName, (String)"attributeName cannot be null.", (Object[])new Object[0]);
            this.enhancedTypeMap.put(attributeName, type);
            this.nonAttributeValueMap.remove(attributeName);
            this.nonAttributeValueMap.put(attributeName, value);
            return this;
        }

        @Override
        public <T> EnhancedDocument.Builder put(String attributeName, T value, Class<T> type) {
            DefaultEnhancedDocument.checkAndValidateClass(type, true);
            this.put(attributeName, value, EnhancedType.of(type));
            return this;
        }

        @Override
        public <K, V> EnhancedDocument.Builder putMap(String attributeName, Map<K, V> value, EnhancedType<K> keyType, EnhancedType<V> valueType) {
            DefaultBuilder.checkInvalidAttribute(attributeName, value);
            Validate.notNull((Object)attributeName, (String)"attributeName cannot be null.", (Object[])new Object[0]);
            Validate.paramNotNull(keyType, (String)"keyType");
            Validate.paramNotNull(valueType, (String)"valueType");
            return this.put(attributeName, value, EnhancedType.mapOf(keyType, valueType));
        }

        @Override
        public EnhancedDocument.Builder putJson(String attributeName, String json) {
            DefaultBuilder.checkInvalidAttribute(attributeName, json);
            return this.putObject(attributeName, DefaultBuilder.getAttributeValueFromJson(json));
        }

        @Override
        public EnhancedDocument.Builder remove(String attributeName) {
            Validate.isTrue((!StringUtils.isEmpty((CharSequence)attributeName) ? 1 : 0) != 0, (String)"Attribute name must not be null or empty", (Object[])new Object[0]);
            this.nonAttributeValueMap.remove(attributeName);
            return this;
        }

        @Override
        public EnhancedDocument.Builder addAttributeConverterProvider(AttributeConverterProvider attributeConverterProvider) {
            Validate.paramNotNull((Object)attributeConverterProvider, (String)"attributeConverterProvider");
            this.attributeConverterProviders.add(attributeConverterProvider);
            return this;
        }

        @Override
        public EnhancedDocument.Builder attributeConverterProviders(List<AttributeConverterProvider> attributeConverterProviders) {
            Validate.paramNotNull(attributeConverterProviders, (String)"attributeConverterProviders");
            this.attributeConverterProviders.clear();
            this.attributeConverterProviders.addAll(attributeConverterProviders);
            return this;
        }

        @Override
        public EnhancedDocument.Builder attributeConverterProviders(AttributeConverterProvider ... attributeConverterProviders) {
            Validate.paramNotNull((Object)attributeConverterProviders, (String)"attributeConverterProviders");
            return this.attributeConverterProviders(Arrays.asList(attributeConverterProviders));
        }

        @Override
        public EnhancedDocument.Builder json(String json) {
            Validate.paramNotNull((Object)json, (String)"json");
            AttributeValue attributeValue = DefaultBuilder.getAttributeValueFromJson(json);
            if (attributeValue != null && attributeValue.hasM()) {
                this.nonAttributeValueMap = new LinkedHashMap<String, Object>(attributeValue.m());
            }
            return this;
        }

        @Override
        public EnhancedDocument.Builder attributeValueMap(Map<String, AttributeValue> attributeValueMap) {
            Validate.paramNotNull(this.attributeConverterProviders, (String)"attributeValueMap");
            this.nonAttributeValueMap.clear();
            attributeValueMap.forEach(this::putObject);
            return this;
        }

        @Override
        public EnhancedDocument build() {
            return new DefaultEnhancedDocument(this);
        }

        private static AttributeValue getAttributeValueFromJson(String json) {
            JsonNodeParser build = JsonNodeParser.builder().build();
            JsonNode jsonNode = build.parse(json);
            if (jsonNode == null) {
                throw new IllegalArgumentException("Could not parse argument json " + json);
            }
            return JSON_ATTRIBUTE_CONVERTER.transformFrom(jsonNode);
        }

        private static void checkInvalidAttribute(String attributeName, Object value) {
            DefaultBuilder.validateAttributeName(attributeName);
            Validate.notNull((Object)value, (String)"Value for %s must not be null. Use putNull API to insert a Null value", (Object[])new Object[]{attributeName});
        }

        private static void validateAttributeName(String attributeName) {
            Validate.isTrue((attributeName != null && !attributeName.trim().isEmpty() ? 1 : 0) != 0, (String)"Attribute name must not be null or empty.", (Object[])new Object[0]);
        }
    }
}

