/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.OptionalLong;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.OptionalLongStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class OptionalLongAttributeConverter
implements AttributeConverter<OptionalLong> {
    private static final Visitor VISITOR = new Visitor();
    private static final OptionalLongStringConverter STRING_CONVERTER = OptionalLongStringConverter.create();

    private OptionalLongAttributeConverter() {
    }

    @Override
    public EnhancedType<OptionalLong> type() {
        return EnhancedType.of(OptionalLong.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    public static OptionalLongAttributeConverter create() {
        return new OptionalLongAttributeConverter();
    }

    @Override
    public AttributeValue transformFrom(OptionalLong input) {
        if (input.isPresent()) {
            return (AttributeValue)AttributeValue.builder().n(STRING_CONVERTER.toString(input)).build();
        }
        return AttributeValues.nullAttributeValue();
    }

    @Override
    public OptionalLong transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<OptionalLong> {
        private Visitor() {
            super(OptionalLong.class, OptionalLongAttributeConverter.class);
        }

        @Override
        public OptionalLong convertNull() {
            return OptionalLong.empty();
        }

        @Override
        public OptionalLong convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public OptionalLong convertNumber(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

