/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.Objects;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;

@SdkPublicApi
@ThreadSafe
public final class PutItemEnhancedRequest<T> {
    private final T item;
    private final Expression conditionExpression;
    private final String returnValues;
    private final String returnConsumedCapacity;
    private final String returnItemCollectionMetrics;

    private PutItemEnhancedRequest(Builder<T> builder) {
        this.item = ((Builder)builder).item;
        this.conditionExpression = ((Builder)builder).conditionExpression;
        this.returnValues = ((Builder)builder).returnValues;
        this.returnConsumedCapacity = ((Builder)builder).returnConsumedCapacity;
        this.returnItemCollectionMetrics = ((Builder)builder).returnItemCollectionMetrics;
    }

    public static <T> Builder<T> builder(Class<? extends T> itemClass) {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return new Builder<T>().item(this.item).conditionExpression(this.conditionExpression).returnValues(this.returnValues).returnConsumedCapacity(this.returnConsumedCapacity).returnItemCollectionMetrics(this.returnItemCollectionMetrics);
    }

    public T item() {
        return this.item;
    }

    public Expression conditionExpression() {
        return this.conditionExpression;
    }

    public ReturnValue returnValues() {
        return ReturnValue.fromValue((String)this.returnValues);
    }

    public String returnValuesAsString() {
        return this.returnValues;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue((String)this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    public ReturnItemCollectionMetrics returnItemCollectionMetrics() {
        return ReturnItemCollectionMetrics.fromValue((String)this.returnItemCollectionMetrics);
    }

    public String returnItemCollectionMetricsAsString() {
        return this.returnItemCollectionMetrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutItemEnhancedRequest that = (PutItemEnhancedRequest)o;
        return Objects.equals(this.item, that.item) && Objects.equals(this.conditionExpression, that.conditionExpression) && Objects.equals(this.returnValues, that.returnValues) && Objects.equals(this.returnConsumedCapacity, that.returnConsumedCapacity) && Objects.equals(this.returnItemCollectionMetrics, that.returnItemCollectionMetrics);
    }

    public int hashCode() {
        int result = this.item != null ? this.item.hashCode() : 0;
        result = 31 * result + (this.conditionExpression != null ? this.conditionExpression.hashCode() : 0);
        result = 31 * result + (this.returnValues != null ? this.returnValues.hashCode() : 0);
        result = 31 * result + (this.returnConsumedCapacity != null ? this.returnConsumedCapacity.hashCode() : 0);
        result = 31 * result + (this.returnItemCollectionMetrics != null ? this.returnItemCollectionMetrics.hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static final class Builder<T> {
        private T item;
        private Expression conditionExpression;
        private String returnValues;
        private String returnConsumedCapacity;
        private String returnItemCollectionMetrics;

        private Builder() {
        }

        public Builder<T> item(T item) {
            this.item = item;
            return this;
        }

        public Builder<T> conditionExpression(Expression conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public Builder<T> returnValues(ReturnValue returnValues) {
            this.returnValues = returnValues == null ? null : returnValues.toString();
            return this;
        }

        public Builder<T> returnValues(String returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        public Builder<T> returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity == null ? null : returnConsumedCapacity.toString();
            return this;
        }

        public Builder<T> returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        public Builder<T> returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics == null ? null : returnItemCollectionMetrics.toString();
            return this;
        }

        public Builder<T> returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        public PutItemEnhancedRequest<T> build() {
            return new PutItemEnhancedRequest(this);
        }
    }
}

