/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.extensions;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbExtensionContext;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.extensions.ReadModification;
import software.amazon.awssdk.enhanced.dynamodb.extensions.WriteModification;
import software.amazon.awssdk.enhanced.dynamodb.internal.extensions.DefaultDynamoDbExtensionContext;
import software.amazon.awssdk.enhanced.dynamodb.update.UpdateExpression;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public final class ChainExtension
implements DynamoDbEnhancedClientExtension {
    private final Deque<DynamoDbEnhancedClientExtension> extensionChain;

    private ChainExtension(List<DynamoDbEnhancedClientExtension> extensions) {
        this.extensionChain = new ArrayDeque<DynamoDbEnhancedClientExtension>(extensions);
    }

    public static ChainExtension create(DynamoDbEnhancedClientExtension ... extensions) {
        return new ChainExtension(Arrays.asList(extensions));
    }

    public static ChainExtension create(List<DynamoDbEnhancedClientExtension> extensions) {
        return new ChainExtension(extensions);
    }

    @Override
    public WriteModification beforeWrite(DynamoDbExtensionContext.BeforeWrite context) {
        Map<String, AttributeValue> transformedItem = null;
        Expression conditionalExpression = null;
        UpdateExpression updateExpression = null;
        for (DynamoDbEnhancedClientExtension extension : this.extensionChain) {
            Map<String, AttributeValue> itemToTransform = transformedItem == null ? context.items() : transformedItem;
            DefaultDynamoDbExtensionContext beforeWrite = DefaultDynamoDbExtensionContext.builder().items(itemToTransform).operationContext(context.operationContext()).tableMetadata(context.tableMetadata()).tableSchema(context.tableSchema()).operationName(context.operationName()).build();
            WriteModification writeModification = extension.beforeWrite(beforeWrite);
            if (writeModification.transformedItem() != null) {
                transformedItem = writeModification.transformedItem();
            }
            conditionalExpression = this.mergeConditionalExpressions(conditionalExpression, writeModification.additionalConditionalExpression());
            updateExpression = this.mergeUpdateExpressions(updateExpression, writeModification.updateExpression());
        }
        return WriteModification.builder().transformedItem(transformedItem).additionalConditionalExpression(conditionalExpression).updateExpression(updateExpression).build();
    }

    private UpdateExpression mergeUpdateExpressions(UpdateExpression existingExpression, UpdateExpression newExpression) {
        if (newExpression != null) {
            existingExpression = existingExpression == null ? newExpression : UpdateExpression.mergeExpressions(existingExpression, newExpression);
        }
        return existingExpression;
    }

    private Expression mergeConditionalExpressions(Expression existingExpression, Expression newExpression) {
        if (newExpression != null) {
            existingExpression = existingExpression == null ? newExpression : existingExpression.and(newExpression);
        }
        return existingExpression;
    }

    @Override
    public ReadModification afterRead(DynamoDbExtensionContext.AfterRead context) {
        Map<String, AttributeValue> transformedItem = null;
        Iterator<DynamoDbEnhancedClientExtension> iterator = this.extensionChain.descendingIterator();
        while (iterator.hasNext()) {
            Map<String, AttributeValue> itemToTransform = transformedItem == null ? context.items() : transformedItem;
            DefaultDynamoDbExtensionContext afterRead = DefaultDynamoDbExtensionContext.builder().items(itemToTransform).operationContext(context.operationContext()).tableMetadata(context.tableMetadata()).tableSchema(context.tableSchema()).build();
            ReadModification readModification = iterator.next().afterRead(afterRead);
            if (readModification.transformedItem() == null) continue;
            transformedItem = readModification.transformedItem();
        }
        return ReadModification.builder().transformedItem(transformedItem).build();
    }
}

