/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class EnumAttributeConverter<T extends Enum<T>>
implements AttributeConverter<T> {
    private final Class<T> enumClass;
    private final Map<String, T> enumValueMap;
    private final Function<T, String> keyExtractor;

    private EnumAttributeConverter(Class<T> enumClass, Function<T, String> keyExtractor) {
        this.enumClass = enumClass;
        this.keyExtractor = keyExtractor;
        LinkedHashMap mutableEnumValueMap = new LinkedHashMap();
        Arrays.stream(enumClass.getEnumConstants()).forEach(enumConstant -> mutableEnumValueMap.put(keyExtractor.apply(enumConstant), enumConstant));
        this.enumValueMap = Collections.unmodifiableMap(mutableEnumValueMap);
    }

    public static <T extends Enum<T>> EnumAttributeConverter<T> create(Class<T> enumClass) {
        return new EnumAttributeConverter<Enum>(enumClass, Enum::toString);
    }

    public static <T extends Enum<T>> EnumAttributeConverter<T> createWithNameAsKeys(Class<T> enumClass) {
        return new EnumAttributeConverter<Enum>(enumClass, Enum::name);
    }

    @Override
    public AttributeValue transformFrom(T input) {
        return (AttributeValue)AttributeValue.builder().s(this.keyExtractor.apply(input)).build();
    }

    @Override
    public T transformTo(AttributeValue input) {
        Validate.isTrue((input.s() != null ? 1 : 0) != 0, (String)"Cannot convert non-string value to enum.", (Object[])new Object[0]);
        Enum returnValue = (Enum)this.enumValueMap.get(input.s());
        if (returnValue == null) {
            throw new IllegalArgumentException(String.format("Unable to convert string value '%s' to enum type '%s'", input.s(), this.enumClass));
        }
        return (T)returnValue;
    }

    @Override
    public EnhancedType<T> type() {
        return EnhancedType.of(this.enumClass);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }
}

