/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.MappedTableResource;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DefaultOperationContext;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DeleteItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.PutItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TransactableWriteOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.UpdateItemOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.ConditionCheck;
import software.amazon.awssdk.enhanced.dynamodb.model.DeleteItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.PutItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.TransactDeleteItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.TransactPutItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.TransactUpdateItemEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.UpdateItemEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;

@SdkPublicApi
@ThreadSafe
public final class TransactWriteItemsEnhancedRequest {
    private final List<TransactWriteItem> transactWriteItems;
    private final String clientRequestToken;

    private TransactWriteItemsEnhancedRequest(Builder builder) {
        this.transactWriteItems = EnhancedClientUtils.getItemsFromSupplier(builder.itemSupplierList);
        this.clientRequestToken = builder.clientRequestToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public List<TransactWriteItem> transactWriteItems() {
        return this.transactWriteItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactWriteItemsEnhancedRequest that = (TransactWriteItemsEnhancedRequest)o;
        return this.transactWriteItems != null ? this.transactWriteItems.equals(that.transactWriteItems) : that.transactWriteItems == null;
    }

    public int hashCode() {
        return this.transactWriteItems != null ? this.transactWriteItems.hashCode() : 0;
    }

    @NotThreadSafe
    public static final class Builder {
        private List<Supplier<TransactWriteItem>> itemSupplierList = new ArrayList<Supplier<TransactWriteItem>>();
        private String clientRequestToken;

        private Builder() {
        }

        public <T> Builder addConditionCheck(MappedTableResource<T> mappedTableResource, ConditionCheck<T> request) {
            this.itemSupplierList.add(() -> this.generateTransactWriteItem(mappedTableResource, request));
            return this;
        }

        public <T> Builder addConditionCheck(MappedTableResource<T> mappedTableResource, Consumer<ConditionCheck.Builder> requestConsumer) {
            ConditionCheck.Builder builder = ConditionCheck.builder();
            requestConsumer.accept(builder);
            return this.addConditionCheck(mappedTableResource, builder.build());
        }

        @Deprecated
        public <T> Builder addDeleteItem(MappedTableResource<T> mappedTableResource, DeleteItemEnhancedRequest request) {
            this.itemSupplierList.add(() -> this.generateTransactWriteItem(mappedTableResource, DeleteItemOperation.create(request)));
            return this;
        }

        public <T> Builder addDeleteItem(MappedTableResource<T> mappedTableResource, TransactDeleteItemEnhancedRequest request) {
            this.itemSupplierList.add(() -> this.generateTransactWriteItem(mappedTableResource, DeleteItemOperation.create(request)));
            return this;
        }

        public <T> Builder addDeleteItem(MappedTableResource<T> mappedTableResource, Key key) {
            return this.addDeleteItem(mappedTableResource, (T)TransactDeleteItemEnhancedRequest.builder().key(key).build());
        }

        public <T> Builder addDeleteItem(MappedTableResource<T> mappedTableResource, T keyItem) {
            return this.addDeleteItem(mappedTableResource, (T)mappedTableResource.keyFrom(keyItem));
        }

        @Deprecated
        public <T> Builder addPutItem(MappedTableResource<T> mappedTableResource, PutItemEnhancedRequest<T> request) {
            this.itemSupplierList.add(() -> this.generateTransactWriteItem(mappedTableResource, PutItemOperation.create(request)));
            return this;
        }

        public <T> Builder addPutItem(MappedTableResource<T> mappedTableResource, TransactPutItemEnhancedRequest<T> request) {
            this.itemSupplierList.add(() -> this.generateTransactWriteItem(mappedTableResource, PutItemOperation.create(request)));
            return this;
        }

        public <T> Builder addPutItem(MappedTableResource<T> mappedTableResource, T item) {
            return this.addPutItem(mappedTableResource, (T)TransactPutItemEnhancedRequest.builder(mappedTableResource.tableSchema().itemType().rawClass()).item(item).build());
        }

        @Deprecated
        public <T> Builder addUpdateItem(MappedTableResource<T> mappedTableResource, UpdateItemEnhancedRequest<T> request) {
            this.itemSupplierList.add(() -> this.generateTransactWriteItem(mappedTableResource, UpdateItemOperation.create(request)));
            return this;
        }

        public <T> Builder addUpdateItem(MappedTableResource<T> mappedTableResource, TransactUpdateItemEnhancedRequest<T> request) {
            this.itemSupplierList.add(() -> this.generateTransactWriteItem(mappedTableResource, UpdateItemOperation.create(request)));
            return this;
        }

        public <T> Builder addUpdateItem(MappedTableResource<T> mappedTableResource, T item) {
            return this.addUpdateItem(mappedTableResource, (T)TransactUpdateItemEnhancedRequest.builder(mappedTableResource.tableSchema().itemType().rawClass()).item(item).build());
        }

        public Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public TransactWriteItemsEnhancedRequest build() {
            return new TransactWriteItemsEnhancedRequest(this);
        }

        private <T> TransactWriteItem generateTransactWriteItem(MappedTableResource<T> mappedTableResource, TransactableWriteOperation<T> generator) {
            return generator.generateTransactWriteItem(mappedTableResource.tableSchema(), DefaultOperationContext.create(mappedTableResource.tableName()), mappedTableResource.mapperExtension());
        }
    }
}

