/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.client;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.extensions.VersionedRecordExtension;
import software.amazon.awssdk.enhanced.dynamodb.internal.extensions.ChainExtension;

@SdkInternalApi
public final class ExtensionResolver {
    private static final DynamoDbEnhancedClientExtension DEFAULT_VERSIONED_RECORD_EXTENSION = VersionedRecordExtension.builder().build();
    private static final List<DynamoDbEnhancedClientExtension> DEFAULT_EXTENSIONS = Collections.singletonList(DEFAULT_VERSIONED_RECORD_EXTENSION);

    private ExtensionResolver() {
    }

    public static List<DynamoDbEnhancedClientExtension> defaultExtensions() {
        return DEFAULT_EXTENSIONS;
    }

    public static DynamoDbEnhancedClientExtension resolveExtensions(List<DynamoDbEnhancedClientExtension> extensions) {
        if (extensions == null || extensions.isEmpty()) {
            return null;
        }
        if (extensions.size() == 1) {
            return extensions.get(0);
        }
        return ChainExtension.create(extensions);
    }
}

