/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
@ThreadSafe
@Immutable
public class SetAttributeConverter<T extends Collection<?>>
implements AttributeConverter<T> {
    private final Delegate<T, ?> delegate;

    private SetAttributeConverter(Delegate<T, ?> delegate) {
        this.delegate = delegate;
    }

    public static <U> SetAttributeConverter<Set<U>> setConverter(AttributeConverter<U> elementConverter) {
        return SetAttributeConverter.builder(EnhancedType.setOf(elementConverter.type())).collectionConstructor(LinkedHashSet::new).elementConverter(elementConverter).build();
    }

    public static <T extends Collection<U>, U> Builder<T, U> builder(EnhancedType<T> collectionType) {
        return new Builder(collectionType);
    }

    @Override
    public EnhancedType<T> type() {
        return this.delegate.type();
    }

    @Override
    public AttributeValueType attributeValueType() {
        return this.delegate.attributeValueType();
    }

    @Override
    public AttributeValue transformFrom(T input) {
        return this.delegate.transformFrom(input);
    }

    @Override
    public T transformTo(AttributeValue input) {
        return (T)this.delegate.transformTo(input);
    }

    public static final class Builder<T extends Collection<U>, U> {
        private final EnhancedType<T> collectionType;
        private Supplier<? extends T> collectionConstructor;
        private AttributeConverter<U> elementConverter;

        private Builder(EnhancedType<T> collectionType) {
            this.collectionType = collectionType;
        }

        public Builder<T, U> collectionConstructor(Supplier<? extends T> collectionConstructor) {
            this.collectionConstructor = collectionConstructor;
            return this;
        }

        public Builder<T, U> elementConverter(AttributeConverter<U> elementConverter) {
            this.elementConverter = elementConverter;
            return this;
        }

        public SetAttributeConverter<T> build() {
            return new SetAttributeConverter(new Delegate(this));
        }
    }

    private static final class Delegate<T extends Collection<U>, U>
    implements AttributeConverter<T> {
        private final EnhancedType<T> type;
        private final Supplier<? extends T> collectionConstructor;
        private final AttributeConverter<U> elementConverter;
        private final AttributeValueType attributeValueType;

        private Delegate(Builder<T, U> builder) {
            this.type = ((Builder)builder).collectionType;
            this.collectionConstructor = ((Builder)builder).collectionConstructor;
            this.elementConverter = ((Builder)builder).elementConverter;
            this.attributeValueType = this.attributeValueTypeForSet(this.elementConverter);
        }

        @Override
        public EnhancedType<T> type() {
            return this.type;
        }

        @Override
        public AttributeValueType attributeValueType() {
            return this.attributeValueType;
        }

        @Override
        public AttributeValue transformFrom(T input) {
            return this.flatten(input.stream().map(this.elementConverter::transformFrom).collect(Collectors.toList()));
        }

        @Override
        public T transformTo(AttributeValue input) {
            return (T)((Collection)EnhancedAttributeValue.fromAttributeValue(input).convert(new TypeConvertingVisitor<T>(this.type.rawClass(), SetAttributeConverter.class){

                @Override
                public T convertSetOfStrings(List<String> value) {
                    return this.convertCollection(value, v -> (AttributeValue)AttributeValue.builder().s(v).build());
                }

                @Override
                public T convertSetOfNumbers(List<String> value) {
                    return this.convertCollection(value, v -> (AttributeValue)AttributeValue.builder().n(v).build());
                }

                @Override
                public T convertSetOfBytes(List<SdkBytes> value) {
                    return this.convertCollection(value, v -> (AttributeValue)AttributeValue.builder().b(v).build());
                }

                @Override
                public T convertListOfAttributeValues(List<AttributeValue> value) {
                    return this.convertCollection(value, Function.identity());
                }

                private <V> T convertCollection(Collection<V> collection, Function<V, AttributeValue> transformFrom) {
                    Collection result = (Collection)collectionConstructor.get();
                    collection.stream().map(transformFrom).map(elementConverter::transformTo).forEach(result::add);
                    return result;
                }
            }));
        }

        private AttributeValueType attributeValueTypeForSet(AttributeConverter<U> innerType) {
            switch (innerType.attributeValueType()) {
                case N: {
                    return AttributeValueType.NS;
                }
                case S: {
                    return AttributeValueType.SS;
                }
                case B: {
                    return AttributeValueType.BS;
                }
            }
            throw new IllegalArgumentException(String.format("SetAttributeConverter cannot be created with a parameterized type of '%s'. Supported parameterized types must convert to B, S or N DynamoDB AttributeValues.", innerType.type().rawClass()));
        }

        public AttributeValue flatten(List<AttributeValue> listOfAttributeValues) {
            Validate.paramNotNull(listOfAttributeValues, (String)"listOfAttributeValues");
            Validate.noNullElements(listOfAttributeValues, (String)"List must not have null values.", (Object[])new Object[0]);
            switch (this.attributeValueType) {
                case NS: {
                    return (AttributeValue)AttributeValue.builder().ns((Collection)listOfAttributeValues.stream().peek(av -> Validate.isTrue((av.n() != null ? 1 : 0) != 0, (String)"Attribute value must be N.", (Object[])new Object[0])).map(AttributeValue::n).collect(Collectors.toList())).build();
                }
                case SS: {
                    return (AttributeValue)AttributeValue.builder().ss((Collection)listOfAttributeValues.stream().peek(av -> Validate.isTrue((av.s() != null ? 1 : 0) != 0, (String)"Attribute value must be S.", (Object[])new Object[0])).map(AttributeValue::s).collect(Collectors.toList())).build();
                }
                case BS: {
                    return (AttributeValue)AttributeValue.builder().bs((Collection)listOfAttributeValues.stream().peek(av -> Validate.isTrue((av.b() != null ? 1 : 0) != 0, (String)"Attribute value must be B.", (Object[])new Object[0])).map(AttributeValue::b).collect(Collectors.toList())).build();
                }
            }
            throw new IllegalStateException("Unsupported set attribute value type: " + (Object)((Object)this.attributeValueType));
        }
    }
}

