/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EnumAttributeConverter<T extends Enum<T>>
implements AttributeConverter<T> {
    private final Class<T> enumClass;
    private final Map<String, T> enumValueMap;

    private EnumAttributeConverter(Class<T> enumClass) {
        this.enumClass = enumClass;
        LinkedHashMap mutableEnumValueMap = new LinkedHashMap();
        Arrays.stream(enumClass.getEnumConstants()).forEach(enumConstant -> mutableEnumValueMap.put(enumConstant.toString(), enumConstant));
        this.enumValueMap = Collections.unmodifiableMap(mutableEnumValueMap);
    }

    public static <T extends Enum<T>> EnumAttributeConverter<T> create(Class<T> enumClass) {
        return new EnumAttributeConverter<T>(enumClass);
    }

    @Override
    public AttributeValue transformFrom(T input) {
        return (AttributeValue)AttributeValue.builder().s(((Enum)input).toString()).build();
    }

    @Override
    public T transformTo(AttributeValue input) {
        Validate.isTrue((input.s() != null ? 1 : 0) != 0, (String)"Cannot convert non-string value to enum.", (Object[])new Object[0]);
        Enum returnValue = (Enum)this.enumValueMap.get(input.s());
        if (returnValue == null) {
            throw new IllegalArgumentException(String.format("Unable to convert string value '%s' to enum type '%s'", input.s(), this.enumClass));
        }
        return (T)returnValue;
    }

    @Override
    public EnhancedType<T> type() {
        return EnhancedType.of(this.enumClass);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }
}

