/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConverterUtils {
    private ConverterUtils() {
    }

    public static void validateDouble(Double input) {
        Validate.isTrue((!Double.isNaN(input) ? 1 : 0) != 0, (String)"NaN is not supported by the default converters.", (Object[])new Object[0]);
        Validate.isTrue((boolean)Double.isFinite(input), (String)"Infinite numbers are not supported by the default converters.", (Object[])new Object[0]);
    }

    public static void validateFloat(Float input) {
        Validate.isTrue((!Float.isNaN(input.floatValue()) ? 1 : 0) != 0, (String)"NaN is not supported by the default converters.", (Object[])new Object[0]);
        Validate.isTrue((boolean)Float.isFinite(input.floatValue()), (String)"Infinite numbers are not supported by the default converters.", (Object[])new Object[0]);
    }

    public static String padLeft2(int valueToPad) {
        return valueToPad > 10 ? Integer.toString(valueToPad) : "0" + valueToPad;
    }

    public static String padLeft(int paddingAmount, int valueToPad) {
        String value = Integer.toString(valueToPad);
        int padding = paddingAmount - value.length();
        StringBuilder result = new StringBuilder(paddingAmount);
        for (int i = 0; i < padding; ++i) {
            result.append('0');
        }
        result.append(value);
        return result.toString();
    }

    public static String padRight(int paddingAmount, String valueToPad) {
        StringBuilder result = new StringBuilder(paddingAmount);
        result.append(valueToPad);
        for (int i = result.length(); i < paddingAmount; ++i) {
            result.append('0');
        }
        return result.toString();
    }

    public static String trimNumber(String number) {
        int startInclusive = ConverterUtils.findTrimInclusiveStart(number, '0', 0);
        if (startInclusive >= number.length()) {
            return "0";
        }
        if (!number.contains(".")) {
            return number.substring(startInclusive);
        }
        int endExclusive = ConverterUtils.findTrimExclusiveEnd(number, '0', number.length());
        if (startInclusive >= (endExclusive = ConverterUtils.findTrimExclusiveEnd(number, '.', endExclusive))) {
            return "0";
        }
        String result = number.substring(startInclusive, endExclusive);
        if (result.startsWith(".")) {
            return "0" + result;
        }
        return result;
    }

    private static int findTrimInclusiveStart(String string, char characterToTrim, int startingIndex) {
        int startInclusive;
        for (startInclusive = startingIndex; startInclusive < string.length() && string.charAt(startInclusive) == characterToTrim; ++startInclusive) {
        }
        return startInclusive;
    }

    private static int findTrimExclusiveEnd(String string, char characterToTrim, int startingIndex) {
        int endExclusive;
        for (endExclusive = startingIndex; endExclusive > 0 && string.charAt(endExclusive - 1) == characterToTrim; --endExclusive) {
        }
        return endExclusive;
    }

    public static String[] splitNumberOnDecimal(String valueToSplit) {
        int i = valueToSplit.indexOf(46);
        if (i == -1) {
            return new String[]{valueToSplit, "0"};
        }
        return new String[]{valueToSplit.substring(0, i), valueToSplit.substring(i + 1)};
    }

    public static String[] chunk(String valueToChunk, int ... splitSizes) {
        String[] result = new String[splitSizes.length + 1];
        int splitStartInclusive = ConverterUtils.chunkLeft(valueToChunk, result, splitSizes);
        Validate.isTrue((splitStartInclusive == valueToChunk.length() ? 1 : 0) != 0, (String)"Value size does not match expected chunking scheme.", (Object[])new Object[0]);
        return result;
    }

    public static String[] chunkWithRightOverflow(String valueToChunk, int ... splitSizesFromLeft) {
        String[] result = new String[splitSizesFromLeft.length + 1];
        int splitStartInclusive = ConverterUtils.chunkLeft(valueToChunk, result, splitSizesFromLeft);
        result[splitSizesFromLeft.length] = valueToChunk.substring(splitStartInclusive);
        return result;
    }

    public static String[] chunkWithLeftOverflow(String valueToChunk, int ... splitSizesFromRight) {
        try {
            String[] result = new String[splitSizesFromRight.length + 1];
            int splitEndExclusive = valueToChunk.length();
            for (int i = splitSizesFromRight.length - 1; i >= 0; --i) {
                int splitStartInclusive = splitEndExclusive - splitSizesFromRight[i];
                result[i + 1] = valueToChunk.substring(splitStartInclusive, splitEndExclusive);
                splitEndExclusive = splitStartInclusive;
            }
            result[0] = valueToChunk.substring(0, splitEndExclusive);
            return result;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid format for value.", e);
        }
    }

    private static int chunkLeft(String valueToChunk, String[] result, int[] splitSizes) {
        try {
            int splitStartInclusive = 0;
            for (int i = 0; i < splitSizes.length; ++i) {
                int splitEndExclusive = splitStartInclusive + splitSizes[i];
                result[i] = valueToChunk.substring(splitStartInclusive, splitEndExclusive);
                splitStartInclusive = splitEndExclusive;
            }
            return splitStartInclusive;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid format for value.", e);
        }
    }
}

