/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.Instant;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.IntegerStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class IntegerAttributeConverter
implements AttributeConverter<Integer>,
PrimitiveConverter<Integer> {
    public static final IntegerStringConverter INTEGER_STRING_CONVERTER = IntegerStringConverter.create();

    private IntegerAttributeConverter() {
    }

    public static IntegerAttributeConverter create() {
        return new IntegerAttributeConverter();
    }

    @Override
    public EnhancedType<Integer> type() {
        return EnhancedType.of(Integer.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(Integer input) {
        return EnhancedAttributeValue.fromNumber(INTEGER_STRING_CONVERTER.toString(input)).toAttributeValue();
    }

    @Override
    public Integer transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(Visitor.INSTANCE);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(Visitor.INSTANCE);
    }

    @Override
    public EnhancedType<Integer> primitiveType() {
        return EnhancedType.of(Integer.TYPE);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<Integer> {
        private static final Visitor INSTANCE = new Visitor();

        private Visitor() {
            super(Instant.class, IntegerAttributeConverter.class);
        }

        @Override
        public Integer convertString(String value) {
            return INTEGER_STRING_CONVERTER.fromString(value);
        }

        @Override
        public Integer convertNumber(String value) {
            return INTEGER_STRING_CONVERTER.fromString(value);
        }
    }
}

