/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;
import software.amazon.awssdk.utils.BinaryUtils;

@SdkInternalApi
@ThreadSafe
@Immutable
public class ByteArrayStringConverter
implements StringConverter<byte[]> {
    private ByteArrayStringConverter() {
    }

    public static ByteArrayStringConverter create() {
        return new ByteArrayStringConverter();
    }

    @Override
    public EnhancedType<byte[]> type() {
        return EnhancedType.of(byte[].class);
    }

    @Override
    public String toString(byte[] object) {
        return BinaryUtils.toBase64((byte[])object);
    }

    @Override
    public byte[] fromString(String string) {
        return BinaryUtils.fromBase64((String)string);
    }
}

