/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.DateTimeException;
import java.time.LocalTime;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.ConverterUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.InstantAsIntegerAttributeConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class LocalTimeAttributeConverter
implements AttributeConverter<LocalTime> {
    private static final Visitor VISITOR = new Visitor();

    private LocalTimeAttributeConverter() {
    }

    public static LocalTimeAttributeConverter create() {
        return new LocalTimeAttributeConverter();
    }

    @Override
    public EnhancedType<LocalTime> type() {
        return EnhancedType.of(LocalTime.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(LocalTime input) {
        String value = "" + ConverterUtils.padLeft2(input.getHour()) + ConverterUtils.padLeft2(input.getMinute()) + ConverterUtils.padLeft2(input.getSecond()) + (input.getNano() == 0 ? "" : "." + ConverterUtils.padLeft(9, input.getNano()));
        return EnhancedAttributeValue.fromNumber(value).toAttributeValue();
    }

    @Override
    public LocalTime transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<LocalTime> {
        private Visitor() {
            super(LocalTime.class, InstantAsIntegerAttributeConverter.class);
        }

        @Override
        public LocalTime convertNumber(String value) {
            String[] splitOnDecimal = ConverterUtils.splitNumberOnDecimal(value);
            String[] chunkedTime = ConverterUtils.chunk(splitOnDecimal[0], 2, 2, 2);
            try {
                return LocalTime.of(Integer.parseInt(chunkedTime[0]), Integer.parseInt(chunkedTime[1]), Integer.parseInt(chunkedTime[2]), Integer.parseInt(splitOnDecimal[1]));
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

