/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.conditional;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
class QueryConditionalKeyValues {
    private final String partitionKey;
    private final AttributeValue partitionValue;
    private final String sortKey;
    private final AttributeValue sortValue;

    private QueryConditionalKeyValues(String partitionKey, AttributeValue partitionValue, String sortKey, AttributeValue sortValue) {
        this.partitionKey = partitionKey;
        this.partitionValue = partitionValue;
        this.sortKey = sortKey;
        this.sortValue = sortValue;
    }

    static QueryConditionalKeyValues from(Key key, TableSchema<?> tableSchema, String indexName) {
        String partitionKey = tableSchema.tableMetadata().indexPartitionKey(indexName);
        AttributeValue partitionValue = key.partitionKeyValue();
        String sortKey = tableSchema.tableMetadata().indexSortKey(indexName).orElseThrow(() -> new IllegalArgumentException("A query conditional requires a sort key to be present on the table or index being queried, yet none have been defined in the model"));
        AttributeValue sortValue = key.sortKeyValue().orElseThrow(() -> new IllegalArgumentException("A query conditional requires a sort key to compare with, however one was not provided."));
        return new QueryConditionalKeyValues(partitionKey, partitionValue, sortKey, sortValue);
    }

    String partitionKey() {
        return this.partitionKey;
    }

    AttributeValue partitionValue() {
        return this.partitionValue;
    }

    String sortKey() {
        return this.sortKey;
    }

    AttributeValue sortValue() {
        return this.sortValue;
    }
}

