/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.BatchableWriteOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableWriteOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.extensions.WriteModification;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Put;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkPublicApi
public class PutItem<T>
implements BatchableWriteOperation<T>,
TransactableWriteOperation<T>,
TableOperation<T, PutItemRequest, PutItemResponse, Void> {
    private final T item;

    private PutItem(T item) {
        this.item = item;
    }

    public static <T> PutItem<T> of(T item) {
        return new PutItem<T>(item);
    }

    public static GenericBuilder builder() {
        return new GenericBuilder();
    }

    public Builder<T> toBuilder() {
        return new Builder<T>().item(this.item);
    }

    @Override
    public PutItemRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        WriteModification transformation;
        if (!TableMetadata.getPrimaryIndexName().equals(operationContext.getIndexName())) {
            throw new IllegalArgumentException("PutItem cannot be executed against a secondary index.");
        }
        tableSchema.getTableMetadata().getPrimaryPartitionKey();
        Map<String, AttributeValue> itemMap = tableSchema.itemToMap(this.item, true);
        TableMetadata tableMetadata = tableSchema.getTableMetadata();
        WriteModification writeModification = transformation = mapperExtension != null ? mapperExtension.beforeWrite(itemMap, operationContext, tableMetadata) : null;
        if (transformation != null && transformation.getTransformedItem() != null) {
            itemMap = transformation.getTransformedItem();
        }
        PutItemRequest.Builder baseRequest = PutItemRequest.builder().tableName(operationContext.getTableName()).item(itemMap);
        if (transformation != null && transformation.getAdditionalConditionalExpression() != null) {
            baseRequest = baseRequest.conditionExpression(transformation.getAdditionalConditionalExpression().getExpression()).expressionAttributeValues(transformation.getAdditionalConditionalExpression().getExpressionValues()).expressionAttributeNames(transformation.getAdditionalConditionalExpression().getExpressionNames());
        }
        return (PutItemRequest)baseRequest.build();
    }

    @Override
    public Void transformResponse(PutItemResponse response, TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        return null;
    }

    @Override
    public Function<PutItemRequest, PutItemResponse> getServiceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).putItem(arg_0);
    }

    @Override
    public WriteRequest generateWriteRequest(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        PutItemRequest putItemRequest = this.generateRequest(tableSchema, operationContext, mapperExtension);
        if (putItemRequest.conditionExpression() != null) {
            throw new IllegalArgumentException("A mapper extension inserted a conditionExpression in a PutItem request as part of a BatchWriteItemRequest. This is not supported by DynamoDb. An extension known to do this is the VersionedRecordExtension.");
        }
        return (WriteRequest)WriteRequest.builder().putRequest((PutRequest)PutRequest.builder().item(putItemRequest.item()).build()).build();
    }

    @Override
    public TransactWriteItem generateTransactWriteItem(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        PutItemRequest putItemRequest = this.generateRequest(tableSchema, operationContext, mapperExtension);
        Put put = (Put)Put.builder().item(putItemRequest.item()).tableName(putItemRequest.tableName()).conditionExpression(putItemRequest.conditionExpression()).expressionAttributeValues(putItemRequest.expressionAttributeValues()).expressionAttributeNames(putItemRequest.expressionAttributeNames()).build();
        return (TransactWriteItem)TransactWriteItem.builder().put(put).build();
    }

    public T getItem() {
        return this.item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutItem putItem = (PutItem)o;
        return this.item != null ? this.item.equals(putItem.item) : putItem.item == null;
    }

    public int hashCode() {
        return this.item != null ? this.item.hashCode() : 0;
    }

    public static final class Builder<T> {
        private T item;

        private Builder() {
        }

        public Builder<T> item(T item) {
            this.item = item;
            return this;
        }

        public PutItem<T> build() {
            return new PutItem(this.item);
        }
    }

    public static class GenericBuilder {
        private GenericBuilder() {
        }

        public <T> Builder<T> item(T item) {
            return new Builder<T>().item(item);
        }

        public PutItem<?> build() {
            throw new UnsupportedOperationException("Cannot construct a PutItem operation without an item to put.");
        }
    }
}

