/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.GlobalSecondaryIndex;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;

@SdkPublicApi
public class CreateTable<T>
implements TableOperation<T, CreateTableRequest, CreateTableResponse, Void> {
    private final ProvisionedThroughput provisionedThroughput;
    private final Collection<LocalSecondaryIndex> localSecondaryIndices;
    private final Collection<GlobalSecondaryIndex> globalSecondaryIndices;

    private CreateTable(ProvisionedThroughput provisionedThroughput, Collection<LocalSecondaryIndex> localSecondaryIndices, Collection<GlobalSecondaryIndex> globalSecondaryIndices) {
        this.provisionedThroughput = provisionedThroughput;
        this.localSecondaryIndices = localSecondaryIndices;
        this.globalSecondaryIndices = globalSecondaryIndices;
    }

    public static <T> CreateTable<T> of(ProvisionedThroughput provisionedThroughput) {
        return new CreateTable<T>(provisionedThroughput, null, null);
    }

    public static <T> CreateTable<T> create() {
        return new CreateTable<T>(null, null, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().provisionedThroughput(this.provisionedThroughput).localSecondaryIndices(this.localSecondaryIndices).globalSecondaryIndices(this.globalSecondaryIndices);
    }

    @Override
    public CreateTableRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        if (!TableMetadata.getPrimaryIndexName().equals(operationContext.getIndexName())) {
            throw new IllegalArgumentException("PutItem cannot be executed against a secondary index.");
        }
        String primaryPartitionKey = tableSchema.getTableMetadata().getPrimaryPartitionKey();
        Optional<String> primarySortKey = tableSchema.getTableMetadata().getPrimarySortKey();
        HashSet<String> dedupedIndexKeys = new HashSet<String>();
        dedupedIndexKeys.add(primaryPartitionKey);
        primarySortKey.ifPresent(dedupedIndexKeys::add);
        List sdkGlobalSecondaryIndices = null;
        List sdkLocalSecondaryIndices = null;
        if (this.globalSecondaryIndices != null) {
            sdkGlobalSecondaryIndices = this.globalSecondaryIndices.stream().map(gsi -> {
                String indexPartitionKey = tableSchema.getTableMetadata().getIndexPartitionKey(gsi.getIndexName());
                Optional<String> indexSortKey = tableSchema.getTableMetadata().getIndexSortKey(gsi.getIndexName());
                dedupedIndexKeys.add(indexPartitionKey);
                indexSortKey.ifPresent(dedupedIndexKeys::add);
                return (software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex)software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex.builder().indexName(gsi.getIndexName()).keySchema(CreateTable.generateKeySchema(indexPartitionKey, indexSortKey.orElse(null))).projection(gsi.getProjection()).provisionedThroughput(gsi.getProvisionedThroughput()).build();
            }).collect(Collectors.toList());
        }
        if (this.localSecondaryIndices != null) {
            sdkLocalSecondaryIndices = this.localSecondaryIndices.stream().map(lsi -> {
                Optional<String> indexSortKey = tableSchema.getTableMetadata().getIndexSortKey(lsi.getIndexName());
                indexSortKey.ifPresent(dedupedIndexKeys::add);
                if (!primaryPartitionKey.equals(tableSchema.getTableMetadata().getIndexPartitionKey(lsi.getIndexName()))) {
                    throw new IllegalArgumentException("Attempt to create a local secondary index with a partition key that is not the primary partition key. Index name: " + lsi.getIndexName());
                }
                return (software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex)software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex.builder().indexName(lsi.getIndexName()).keySchema(CreateTable.generateKeySchema(primaryPartitionKey, indexSortKey.orElse(null))).projection(lsi.getProjection()).build();
            }).collect(Collectors.toList());
        }
        List attributeDefinitions = dedupedIndexKeys.stream().map(attribute -> (AttributeDefinition)AttributeDefinition.builder().attributeName(attribute).attributeType(tableSchema.getTableMetadata().getScalarAttributeType((String)attribute).orElseThrow(() -> new IllegalArgumentException("Could not map the key attribute '" + attribute + "' to a valid scalar type."))).build()).collect(Collectors.toList());
        BillingMode billingMode = this.provisionedThroughput == null ? BillingMode.PAY_PER_REQUEST : BillingMode.PROVISIONED;
        return (CreateTableRequest)CreateTableRequest.builder().tableName(operationContext.getTableName()).keySchema(CreateTable.generateKeySchema(primaryPartitionKey, primarySortKey.orElse(null))).globalSecondaryIndexes(sdkGlobalSecondaryIndices).localSecondaryIndexes(sdkLocalSecondaryIndices).attributeDefinitions(attributeDefinitions).billingMode(billingMode).provisionedThroughput(this.provisionedThroughput).build();
    }

    @Override
    public Function<CreateTableRequest, CreateTableResponse> getServiceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).createTable(arg_0);
    }

    @Override
    public Void transformResponse(CreateTableResponse response, TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        return null;
    }

    public ProvisionedThroughput getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public Collection<LocalSecondaryIndex> getLocalSecondaryIndices() {
        return this.localSecondaryIndices;
    }

    public Collection<GlobalSecondaryIndex> getGlobalSecondaryIndices() {
        return this.globalSecondaryIndices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTable that = (CreateTable)o;
        if (this.provisionedThroughput != null ? !this.provisionedThroughput.equals((Object)that.provisionedThroughput) : that.provisionedThroughput != null) {
            return false;
        }
        if (this.localSecondaryIndices != null ? !this.localSecondaryIndices.equals(that.localSecondaryIndices) : that.localSecondaryIndices != null) {
            return false;
        }
        return this.globalSecondaryIndices != null ? this.globalSecondaryIndices.equals(that.globalSecondaryIndices) : that.globalSecondaryIndices == null;
    }

    public int hashCode() {
        int result = this.provisionedThroughput != null ? this.provisionedThroughput.hashCode() : 0;
        result = 31 * result + (this.localSecondaryIndices != null ? this.localSecondaryIndices.hashCode() : 0);
        result = 31 * result + (this.globalSecondaryIndices != null ? this.globalSecondaryIndices.hashCode() : 0);
        return result;
    }

    private static Collection<KeySchemaElement> generateKeySchema(String partitionKey, String sortKey) {
        if (sortKey == null) {
            return CreateTable.generateKeySchema(partitionKey);
        }
        return Collections.unmodifiableList(Arrays.asList((KeySchemaElement)KeySchemaElement.builder().attributeName(partitionKey).keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName(sortKey).keyType(KeyType.RANGE).build()));
    }

    private static Collection<KeySchemaElement> generateKeySchema(String partitionKey) {
        return Collections.singletonList(KeySchemaElement.builder().attributeName(partitionKey).keyType(KeyType.HASH).build());
    }

    public static final class Builder {
        private ProvisionedThroughput provisionedThroughput;
        private Collection<LocalSecondaryIndex> localSecondaryIndices;
        private Collection<GlobalSecondaryIndex> globalSecondaryIndices;

        private Builder() {
        }

        public Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public Builder localSecondaryIndices(Collection<LocalSecondaryIndex> localSecondaryIndices) {
            this.localSecondaryIndices = localSecondaryIndices;
            return this;
        }

        public Builder localSecondaryIndices(LocalSecondaryIndex ... localSecondaryIndices) {
            this.localSecondaryIndices = Arrays.asList(localSecondaryIndices);
            return this;
        }

        public Builder globalSecondaryIndices(Collection<GlobalSecondaryIndex> globalSecondaryIndices) {
            this.globalSecondaryIndices = globalSecondaryIndices;
            return this;
        }

        public Builder globalSecondaryIndices(GlobalSecondaryIndex ... globalSecondaryIndices) {
            this.globalSecondaryIndices = Arrays.asList(globalSecondaryIndices);
            return this;
        }

        public <T> CreateTable<T> build() {
            return new CreateTable(this.provisionedThroughput, this.localSecondaryIndices, this.globalSecondaryIndices);
        }
    }
}

