/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public final class TransactGetResultPage {
    private final Map<String, AttributeValue> itemMap;

    private TransactGetResultPage(Map<String, AttributeValue> itemMap) {
        this.itemMap = itemMap;
    }

    public static TransactGetResultPage create(Map<String, AttributeValue> itemMap) {
        return new TransactGetResultPage(itemMap);
    }

    public <T> T getItem(MappedTableResource<T> mappedTableResource) {
        return Utils.readAndTransformSingleItem(this.itemMap, mappedTableResource.tableSchema(), OperationContext.create(mappedTableResource.tableName()), mappedTableResource.mapperExtension());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactGetResultPage that = (TransactGetResultPage)o;
        return this.itemMap != null ? this.itemMap.equals(that.itemMap) : that.itemMap == null;
    }

    public int hashCode() {
        return this.itemMap != null ? this.itemMap.hashCode() : 0;
    }
}

