/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public final class ScanEnhancedRequest {
    private final Map<String, AttributeValue> exclusiveStartKey;
    private final Integer limit;
    private final Boolean consistentRead;
    private final Expression filterExpression;

    private ScanEnhancedRequest(Builder builder) {
        this.exclusiveStartKey = builder.exclusiveStartKey;
        this.limit = builder.limit;
        this.consistentRead = builder.consistentRead;
        this.filterExpression = builder.filterExpression;
    }

    public static ScanEnhancedRequest create() {
        return ScanEnhancedRequest.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ScanEnhancedRequest.builder().exclusiveStartKey(this.exclusiveStartKey).limit(this.limit).consistentRead(this.consistentRead).filterExpression(this.filterExpression);
    }

    public Map<String, AttributeValue> exclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public Integer limit() {
        return this.limit;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public Expression filterExpression() {
        return this.filterExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanEnhancedRequest scan = (ScanEnhancedRequest)o;
        if (this.exclusiveStartKey != null ? !this.exclusiveStartKey.equals(scan.exclusiveStartKey) : scan.exclusiveStartKey != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(scan.limit) : scan.limit != null) {
            return false;
        }
        if (this.consistentRead != null ? !this.consistentRead.equals(scan.consistentRead) : scan.consistentRead != null) {
            return false;
        }
        return this.filterExpression != null ? this.filterExpression.equals(scan.filterExpression) : scan.filterExpression == null;
    }

    public int hashCode() {
        int result = this.exclusiveStartKey != null ? this.exclusiveStartKey.hashCode() : 0;
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.consistentRead != null ? this.consistentRead.hashCode() : 0);
        result = 31 * result + (this.filterExpression != null ? this.filterExpression.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private Map<String, AttributeValue> exclusiveStartKey;
        private Integer limit;
        private Boolean consistentRead;
        private Expression filterExpression;

        private Builder() {
        }

        public Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = new HashMap<String, AttributeValue>(exclusiveStartKey);
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public Builder filterExpression(Expression filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public ScanEnhancedRequest build() {
            return new ScanEnhancedRequest(this);
        }
    }
}

