/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;

@SdkPublicApi
public final class PutItemEnhancedRequest<T> {
    private final T item;
    private final Expression conditionExpression;

    private PutItemEnhancedRequest(Builder<T> builder) {
        this.item = ((Builder)builder).item;
        this.conditionExpression = ((Builder)builder).conditionExpression;
    }

    public static <T> PutItemEnhancedRequest<T> create(T item) {
        return new Builder<T>().item(item).build();
    }

    public static <T> Builder<T> builder(Class<? extends T> itemClass) {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return new Builder<T>().item(this.item).conditionExpression(this.conditionExpression);
    }

    public T item() {
        return this.item;
    }

    public Expression conditionExpression() {
        return this.conditionExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutItemEnhancedRequest putItem = (PutItemEnhancedRequest)o;
        return this.item != null ? this.item.equals(putItem.item) : putItem.item == null;
    }

    public int hashCode() {
        return this.item != null ? this.item.hashCode() : 0;
    }

    public static final class Builder<T> {
        private T item;
        private Expression conditionExpression;

        private Builder() {
        }

        public Builder<T> item(T item) {
            this.item = item;
            return this;
        }

        public Builder<T> conditionExpression(Expression conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public PutItemEnhancedRequest<T> build() {
            return new PutItemEnhancedRequest(this);
        }
    }
}

