/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.core;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public class TransformIterator<T, R>
implements Iterator<R> {
    private final Iterator<T> wrappedIterator;
    private final Function<T, R> transformFunction;

    private TransformIterator(Iterator<T> wrappedIterator, Function<T, R> transformFunction) {
        this.wrappedIterator = wrappedIterator;
        this.transformFunction = transformFunction;
    }

    public static <T, R> TransformIterator<T, R> create(Iterator<T> iterator, Function<T, R> transformFunction) {
        return new TransformIterator<T, R>(iterator, transformFunction);
    }

    @Override
    public boolean hasNext() {
        return this.wrappedIterator.hasNext();
    }

    @Override
    public R next() {
        return this.transformFunction.apply(this.wrappedIterator.next());
    }
}

