/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.BatchableWriteOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableWriteOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.extensions.WriteModification;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Put;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkPublicApi
public class PutItem<T>
implements BatchableWriteOperation<T>,
TransactableWriteOperation<T>,
TableOperation<T, PutItemRequest, PutItemResponse, Void> {
    private final T item;
    private final Expression conditionExpression;

    private PutItem(Builder<T> b) {
        this.item = ((Builder)b).item;
        this.conditionExpression = ((Builder)b).conditionExpression;
    }

    public static <T> PutItem<T> create(T item) {
        return new Builder<T>().item(item).build();
    }

    public static <T> Builder<T> builder(Class<? extends T> itemClass) {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return new Builder<T>().item(this.item).conditionExpression(this.conditionExpression);
    }

    @Override
    public PutItemRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        WriteModification transformation;
        if (!TableMetadata.primaryIndexName().equals(operationContext.indexName())) {
            throw new IllegalArgumentException("PutItem cannot be executed against a secondary index.");
        }
        tableSchema.tableMetadata().primaryPartitionKey();
        Map<String, AttributeValue> itemMap = tableSchema.itemToMap(this.item, true);
        TableMetadata tableMetadata = tableSchema.tableMetadata();
        WriteModification writeModification = transformation = mapperExtension != null ? mapperExtension.beforeWrite(itemMap, operationContext, tableMetadata) : null;
        if (transformation != null && transformation.transformedItem() != null) {
            itemMap = transformation.transformedItem();
        }
        PutItemRequest.Builder baseRequest = PutItemRequest.builder().tableName(operationContext.tableName()).item(itemMap);
        Expression mergedConditionExpression = transformation != null && transformation.additionalConditionalExpression() != null ? Expression.coalesce(this.conditionExpression, transformation.additionalConditionalExpression(), " AND ") : this.conditionExpression;
        if (mergedConditionExpression != null) {
            baseRequest = baseRequest.conditionExpression(mergedConditionExpression.expression());
            if (mergedConditionExpression.expressionValues() != null && !mergedConditionExpression.expressionValues().isEmpty()) {
                baseRequest = baseRequest.expressionAttributeValues(mergedConditionExpression.expressionValues());
            }
            if (mergedConditionExpression.expressionNames() != null && !mergedConditionExpression.expressionNames().isEmpty()) {
                baseRequest = baseRequest.expressionAttributeNames(mergedConditionExpression.expressionNames());
            }
        }
        return (PutItemRequest)baseRequest.build();
    }

    @Override
    public Void transformResponse(PutItemResponse response, TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        return null;
    }

    @Override
    public Function<PutItemRequest, PutItemResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).putItem(arg_0);
    }

    @Override
    public Function<PutItemRequest, CompletableFuture<PutItemResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).putItem(arg_0);
    }

    @Override
    public WriteRequest generateWriteRequest(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        PutItemRequest putItemRequest = this.generateRequest(tableSchema, operationContext, mapperExtension);
        if (putItemRequest.conditionExpression() != null) {
            throw new IllegalArgumentException("A mapper extension inserted a conditionExpression in a PutItem request as part of a BatchWriteItemRequest. This is not supported by DynamoDb. An extension known to do this is the VersionedRecordExtension.");
        }
        return (WriteRequest)WriteRequest.builder().putRequest((PutRequest)PutRequest.builder().item(putItemRequest.item()).build()).build();
    }

    @Override
    public TransactWriteItem generateTransactWriteItem(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        PutItemRequest putItemRequest = this.generateRequest(tableSchema, operationContext, mapperExtension);
        Put put = (Put)Put.builder().item(putItemRequest.item()).tableName(putItemRequest.tableName()).conditionExpression(putItemRequest.conditionExpression()).expressionAttributeValues(putItemRequest.expressionAttributeValues()).expressionAttributeNames(putItemRequest.expressionAttributeNames()).build();
        return (TransactWriteItem)TransactWriteItem.builder().put(put).build();
    }

    public T item() {
        return this.item;
    }

    public Expression conditionExpression() {
        return this.conditionExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutItem putItem = (PutItem)o;
        return this.item != null ? this.item.equals(putItem.item) : putItem.item == null;
    }

    public int hashCode() {
        return this.item != null ? this.item.hashCode() : 0;
    }

    public static final class Builder<T> {
        private T item;
        private Expression conditionExpression;

        private Builder() {
        }

        public Builder<T> item(T item) {
            this.item = item;
            return this;
        }

        public Builder<T> conditionExpression(Expression conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public PutItem<T> build() {
            return new PutItem(this);
        }
    }
}

