/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.core;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.DatabaseOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.DynamoDbEnhancedAsyncClient;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.DynamoDbAsyncMappedTable;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;

@SdkInternalApi
@ThreadSafe
public final class DefaultDynamoDbEnhancedAsyncClient
implements DynamoDbEnhancedAsyncClient {
    private final DynamoDbAsyncClient dynamoDbClient;
    private final MapperExtension mapperExtension;

    private DefaultDynamoDbEnhancedAsyncClient(DynamoDbAsyncClient dynamoDbClient, MapperExtension mapperExtension) {
        this.dynamoDbClient = dynamoDbClient;
        this.mapperExtension = mapperExtension;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> CompletableFuture<T> execute(DatabaseOperation<?, ?, T> operation) {
        return operation.executeAsync(this.dynamoDbClient, this.mapperExtension);
    }

    public <T> DynamoDbAsyncMappedTable<T> table(String tableName, TableSchema<T> tableSchema) {
        return new DynamoDbAsyncMappedTable<T>(this.dynamoDbClient, this.mapperExtension, tableSchema, tableName);
    }

    public DynamoDbAsyncClient dynamoDbAsyncClient() {
        return this.dynamoDbClient;
    }

    public MapperExtension mapperExtension() {
        return this.mapperExtension;
    }

    public Builder toBuilder() {
        return DefaultDynamoDbEnhancedAsyncClient.builder().dynamoDbClient(this.dynamoDbClient).extendWith(this.mapperExtension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDynamoDbEnhancedAsyncClient that = (DefaultDynamoDbEnhancedAsyncClient)o;
        if (this.dynamoDbClient != null ? !this.dynamoDbClient.equals(that.dynamoDbClient) : that.dynamoDbClient != null) {
            return false;
        }
        return this.mapperExtension != null ? this.mapperExtension.equals(that.mapperExtension) : that.mapperExtension == null;
    }

    public int hashCode() {
        int result = this.dynamoDbClient != null ? this.dynamoDbClient.hashCode() : 0;
        result = 31 * result + (this.mapperExtension != null ? this.mapperExtension.hashCode() : 0);
        return result;
    }

    public static final class Builder
    implements DynamoDbEnhancedAsyncClient.Builder {
        private DynamoDbAsyncClient dynamoDbClient;
        private MapperExtension mapperExtension;

        private Builder() {
        }

        @Override
        public DefaultDynamoDbEnhancedAsyncClient build() {
            if (this.dynamoDbClient == null) {
                throw new IllegalArgumentException("You must provide a DynamoDbClient to build a DefaultDynamoDbEnhancedClient.");
            }
            return new DefaultDynamoDbEnhancedAsyncClient(this.dynamoDbClient, this.mapperExtension);
        }

        @Override
        public Builder dynamoDbClient(DynamoDbAsyncClient dynamoDbAsyncClient) {
            this.dynamoDbClient = dynamoDbAsyncClient;
            return this;
        }

        @Override
        public Builder extendWith(MapperExtension mapperExtension) {
            if (mapperExtension != null && this.mapperExtension != null) {
                throw new IllegalArgumentException("You may only extend a DefaultDynamoDbEnhancedClient with a single extension. To combine multiple extensions, use the ChainMapperExtension.");
            }
            this.mapperExtension = mapperExtension;
            return this;
        }
    }
}

