/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dsql.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteMultiRegionClustersRequest extends DsqlRequest implements
        ToCopyableBuilder<DeleteMultiRegionClustersRequest.Builder, DeleteMultiRegionClustersRequest> {
    private static final SdkField<List<String>> LINKED_CLUSTER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("linkedClusterArns")
            .getter(getter(DeleteMultiRegionClustersRequest::linkedClusterArns))
            .setter(setter(Builder::linkedClusterArns))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("linked-cluster-arns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(DeleteMultiRegionClustersRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("client-token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINKED_CLUSTER_ARNS_FIELD,
            CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> linkedClusterArns;

    private final String clientToken;

    private DeleteMultiRegionClustersRequest(BuilderImpl builder) {
        super(builder);
        this.linkedClusterArns = builder.linkedClusterArns;
        this.clientToken = builder.clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LinkedClusterArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLinkedClusterArns() {
        return linkedClusterArns != null && !(linkedClusterArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the clusters linked to the cluster you want to delete. also deletes these clusters as part of the
     * operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkedClusterArns} method.
     * </p>
     * 
     * @return The ARNs of the clusters linked to the cluster you want to delete. also deletes these clusters as part of
     *         the operation.
     */
    public final List<String> linkedClusterArns() {
        return linkedClusterArns;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully. The subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully. The subsequent retries with the same client token return the result from
     *         the original successful request and they have no additional effect.</p>
     *         <p>
     *         If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLinkedClusterArns() ? linkedClusterArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMultiRegionClustersRequest)) {
            return false;
        }
        DeleteMultiRegionClustersRequest other = (DeleteMultiRegionClustersRequest) obj;
        return hasLinkedClusterArns() == other.hasLinkedClusterArns()
                && Objects.equals(linkedClusterArns(), other.linkedClusterArns())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteMultiRegionClustersRequest")
                .add("LinkedClusterArns", hasLinkedClusterArns() ? linkedClusterArns() : null).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "linkedClusterArns":
            return Optional.ofNullable(clazz.cast(linkedClusterArns()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("linked-cluster-arns", LINKED_CLUSTER_ARNS_FIELD);
        map.put("client-token", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteMultiRegionClustersRequest, T> g) {
        return obj -> g.apply((DeleteMultiRegionClustersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DsqlRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteMultiRegionClustersRequest> {
        /**
         * <p>
         * The ARNs of the clusters linked to the cluster you want to delete. also deletes these clusters as part of the
         * operation.
         * </p>
         * 
         * @param linkedClusterArns
         *        The ARNs of the clusters linked to the cluster you want to delete. also deletes these clusters as part
         *        of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedClusterArns(Collection<String> linkedClusterArns);

        /**
         * <p>
         * The ARNs of the clusters linked to the cluster you want to delete. also deletes these clusters as part of the
         * operation.
         * </p>
         * 
         * @param linkedClusterArns
         *        The ARNs of the clusters linked to the cluster you want to delete. also deletes these clusters as part
         *        of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedClusterArns(String... linkedClusterArns);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully. The subsequent retries with the same client token return the result from the original
         * successful request and they have no additional effect.
         * </p>
         * <p>
         * If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully. The subsequent retries with the same client token return the
         *        result from the original successful request and they have no additional effect.</p>
         *        <p>
         *        If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DsqlRequest.BuilderImpl implements Builder {
        private List<String> linkedClusterArns = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMultiRegionClustersRequest model) {
            super(model);
            linkedClusterArns(model.linkedClusterArns);
            clientToken(model.clientToken);
        }

        public final Collection<String> getLinkedClusterArns() {
            if (linkedClusterArns instanceof SdkAutoConstructList) {
                return null;
            }
            return linkedClusterArns;
        }

        public final void setLinkedClusterArns(Collection<String> linkedClusterArns) {
            this.linkedClusterArns = ClusterArnListCopier.copy(linkedClusterArns);
        }

        @Override
        public final Builder linkedClusterArns(Collection<String> linkedClusterArns) {
            this.linkedClusterArns = ClusterArnListCopier.copy(linkedClusterArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedClusterArns(String... linkedClusterArns) {
            linkedClusterArns(Arrays.asList(linkedClusterArns));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteMultiRegionClustersRequest build() {
            return new DeleteMultiRegionClustersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
