/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dsql.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMultiRegionClustersRequest extends DsqlRequest implements
        ToCopyableBuilder<CreateMultiRegionClustersRequest.Builder, CreateMultiRegionClustersRequest> {
    private static final SdkField<List<String>> LINKED_REGION_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("linkedRegionList")
            .getter(getter(CreateMultiRegionClustersRequest::linkedRegionList))
            .setter(setter(Builder::linkedRegionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkedRegionList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, LinkedClusterProperties>> CLUSTER_PROPERTIES_FIELD = SdkField
            .<Map<String, LinkedClusterProperties>> builder(MarshallingType.MAP)
            .memberName("clusterProperties")
            .getter(getter(CreateMultiRegionClustersRequest::clusterProperties))
            .setter(setter(Builder::clusterProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LinkedClusterProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(LinkedClusterProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WITNESS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("witnessRegion").getter(getter(CreateMultiRegionClustersRequest::witnessRegion))
            .setter(setter(Builder::witnessRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("witnessRegion").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateMultiRegionClustersRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINKED_REGION_LIST_FIELD,
            CLUSTER_PROPERTIES_FIELD, WITNESS_REGION_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> linkedRegionList;

    private final Map<String, LinkedClusterProperties> clusterProperties;

    private final String witnessRegion;

    private final String clientToken;

    private CreateMultiRegionClustersRequest(BuilderImpl builder) {
        super(builder);
        this.linkedRegionList = builder.linkedRegionList;
        this.clusterProperties = builder.clusterProperties;
        this.witnessRegion = builder.witnessRegion;
        this.clientToken = builder.clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LinkedRegionList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLinkedRegionList() {
        return linkedRegionList != null && !(linkedRegionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the Regions in which you want to create additional clusters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkedRegionList} method.
     * </p>
     * 
     * @return An array of the Regions in which you want to create additional clusters.
     */
    public final List<String> linkedRegionList() {
        return linkedRegionList;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterProperties() {
        return clusterProperties != null && !(clusterProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping of properties to use when creating linked clusters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterProperties} method.
     * </p>
     * 
     * @return A mapping of properties to use when creating linked clusters.
     */
    public final Map<String, LinkedClusterProperties> clusterProperties() {
        return clusterProperties;
    }

    /**
     * <p>
     * The witness Region of multi-Region clusters.
     * </p>
     * 
     * @return The witness Region of multi-Region clusters.
     */
    public final String witnessRegion() {
        return witnessRegion;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully. The subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully. The subsequent retries with the same client token return the result from
     *         the original successful request and they have no additional effect.</p>
     *         <p>
     *         If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLinkedRegionList() ? linkedRegionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterProperties() ? clusterProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(witnessRegion());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiRegionClustersRequest)) {
            return false;
        }
        CreateMultiRegionClustersRequest other = (CreateMultiRegionClustersRequest) obj;
        return hasLinkedRegionList() == other.hasLinkedRegionList()
                && Objects.equals(linkedRegionList(), other.linkedRegionList())
                && hasClusterProperties() == other.hasClusterProperties()
                && Objects.equals(clusterProperties(), other.clusterProperties())
                && Objects.equals(witnessRegion(), other.witnessRegion()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMultiRegionClustersRequest")
                .add("LinkedRegionList", hasLinkedRegionList() ? linkedRegionList() : null)
                .add("ClusterProperties", hasClusterProperties() ? clusterProperties() : null)
                .add("WitnessRegion", witnessRegion()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "linkedRegionList":
            return Optional.ofNullable(clazz.cast(linkedRegionList()));
        case "clusterProperties":
            return Optional.ofNullable(clazz.cast(clusterProperties()));
        case "witnessRegion":
            return Optional.ofNullable(clazz.cast(witnessRegion()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("linkedRegionList", LINKED_REGION_LIST_FIELD);
        map.put("clusterProperties", CLUSTER_PROPERTIES_FIELD);
        map.put("witnessRegion", WITNESS_REGION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMultiRegionClustersRequest, T> g) {
        return obj -> g.apply((CreateMultiRegionClustersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DsqlRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMultiRegionClustersRequest> {
        /**
         * <p>
         * An array of the Regions in which you want to create additional clusters.
         * </p>
         * 
         * @param linkedRegionList
         *        An array of the Regions in which you want to create additional clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedRegionList(Collection<String> linkedRegionList);

        /**
         * <p>
         * An array of the Regions in which you want to create additional clusters.
         * </p>
         * 
         * @param linkedRegionList
         *        An array of the Regions in which you want to create additional clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedRegionList(String... linkedRegionList);

        /**
         * <p>
         * A mapping of properties to use when creating linked clusters.
         * </p>
         * 
         * @param clusterProperties
         *        A mapping of properties to use when creating linked clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterProperties(Map<String, LinkedClusterProperties> clusterProperties);

        /**
         * <p>
         * The witness Region of multi-Region clusters.
         * </p>
         * 
         * @param witnessRegion
         *        The witness Region of multi-Region clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder witnessRegion(String witnessRegion);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully. The subsequent retries with the same client token return the result from the original
         * successful request and they have no additional effect.
         * </p>
         * <p>
         * If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully. The subsequent retries with the same client token return the
         *        result from the original successful request and they have no additional effect.</p>
         *        <p>
         *        If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DsqlRequest.BuilderImpl implements Builder {
        private List<String> linkedRegionList = DefaultSdkAutoConstructList.getInstance();

        private Map<String, LinkedClusterProperties> clusterProperties = DefaultSdkAutoConstructMap.getInstance();

        private String witnessRegion;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultiRegionClustersRequest model) {
            super(model);
            linkedRegionList(model.linkedRegionList);
            clusterProperties(model.clusterProperties);
            witnessRegion(model.witnessRegion);
            clientToken(model.clientToken);
        }

        public final Collection<String> getLinkedRegionList() {
            if (linkedRegionList instanceof SdkAutoConstructList) {
                return null;
            }
            return linkedRegionList;
        }

        public final void setLinkedRegionList(Collection<String> linkedRegionList) {
            this.linkedRegionList = RegionListCopier.copy(linkedRegionList);
        }

        @Override
        public final Builder linkedRegionList(Collection<String> linkedRegionList) {
            this.linkedRegionList = RegionListCopier.copy(linkedRegionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedRegionList(String... linkedRegionList) {
            linkedRegionList(Arrays.asList(linkedRegionList));
            return this;
        }

        public final Map<String, LinkedClusterProperties.Builder> getClusterProperties() {
            Map<String, LinkedClusterProperties.Builder> result = ClusterPropertyMapCopier.copyToBuilder(this.clusterProperties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setClusterProperties(Map<String, LinkedClusterProperties.BuilderImpl> clusterProperties) {
            this.clusterProperties = ClusterPropertyMapCopier.copyFromBuilder(clusterProperties);
        }

        @Override
        public final Builder clusterProperties(Map<String, LinkedClusterProperties> clusterProperties) {
            this.clusterProperties = ClusterPropertyMapCopier.copy(clusterProperties);
            return this;
        }

        public final String getWitnessRegion() {
            return witnessRegion;
        }

        public final void setWitnessRegion(String witnessRegion) {
            this.witnessRegion = witnessRegion;
        }

        @Override
        public final Builder witnessRegion(String witnessRegion) {
            this.witnessRegion = witnessRegion;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMultiRegionClustersRequest build() {
            return new CreateMultiRegionClustersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
