/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobLogEvent {
    JOB_START("JOB_START"),
    SERVER_SKIPPED("SERVER_SKIPPED"),
    CLEANUP_START("CLEANUP_START"),
    CLEANUP_END("CLEANUP_END"),
    CLEANUP_FAIL("CLEANUP_FAIL"),
    SNAPSHOT_START("SNAPSHOT_START"),
    SNAPSHOT_END("SNAPSHOT_END"),
    SNAPSHOT_FAIL("SNAPSHOT_FAIL"),
    USING_PREVIOUS_SNAPSHOT("USING_PREVIOUS_SNAPSHOT"),
    USING_PREVIOUS_SNAPSHOT_FAILED("USING_PREVIOUS_SNAPSHOT_FAILED"),
    CONVERSION_START("CONVERSION_START"),
    CONVERSION_END("CONVERSION_END"),
    CONVERSION_FAIL("CONVERSION_FAIL"),
    LAUNCH_START("LAUNCH_START"),
    LAUNCH_FAILED("LAUNCH_FAILED"),
    JOB_CANCEL("JOB_CANCEL"),
    JOB_END("JOB_END"),
    DEPLOY_NETWORK_CONFIGURATION_START("DEPLOY_NETWORK_CONFIGURATION_START"),
    DEPLOY_NETWORK_CONFIGURATION_END("DEPLOY_NETWORK_CONFIGURATION_END"),
    DEPLOY_NETWORK_CONFIGURATION_FAILED("DEPLOY_NETWORK_CONFIGURATION_FAILED"),
    UPDATE_NETWORK_CONFIGURATION_START("UPDATE_NETWORK_CONFIGURATION_START"),
    UPDATE_NETWORK_CONFIGURATION_END("UPDATE_NETWORK_CONFIGURATION_END"),
    UPDATE_NETWORK_CONFIGURATION_FAILED("UPDATE_NETWORK_CONFIGURATION_FAILED"),
    UPDATE_LAUNCH_TEMPLATE_START("UPDATE_LAUNCH_TEMPLATE_START"),
    UPDATE_LAUNCH_TEMPLATE_END("UPDATE_LAUNCH_TEMPLATE_END"),
    UPDATE_LAUNCH_TEMPLATE_FAILED("UPDATE_LAUNCH_TEMPLATE_FAILED"),
    NETWORK_RECOVERY_FAIL("NETWORK_RECOVERY_FAIL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobLogEvent> VALUE_MAP;
    private final String value;

    private JobLogEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobLogEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobLogEvent> knownValues() {
        EnumSet<JobLogEvent> knownValues = EnumSet.allOf(JobLogEvent.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobLogEvent.class, JobLogEvent::toString);
    }
}

