/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.drs.model.EbsSnapshotsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecoverySnapshot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecoverySnapshot> {
    private static final SdkField<List<String>> EBS_SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ebsSnapshots").getter(RecoverySnapshot.getter(RecoverySnapshot::ebsSnapshots)).setter(RecoverySnapshot.setter(Builder::ebsSnapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsSnapshots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXPECTED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expectedTimestamp").getter(RecoverySnapshot.getter(RecoverySnapshot::expectedTimestamp)).setter(RecoverySnapshot.setter(Builder::expectedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedTimestamp").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotID").getter(RecoverySnapshot.getter(RecoverySnapshot::snapshotID)).setter(RecoverySnapshot.setter(Builder::snapshotID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotID").build()}).build();
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(RecoverySnapshot.getter(RecoverySnapshot::sourceServerID)).setter(RecoverySnapshot.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timestamp").getter(RecoverySnapshot.getter(RecoverySnapshot::timestamp)).setter(RecoverySnapshot.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_SNAPSHOTS_FIELD, EXPECTED_TIMESTAMP_FIELD, SNAPSHOT_ID_FIELD, SOURCE_SERVER_ID_FIELD, TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> ebsSnapshots;
    private final String expectedTimestamp;
    private final String snapshotID;
    private final String sourceServerID;
    private final String timestamp;

    private RecoverySnapshot(BuilderImpl builder) {
        this.ebsSnapshots = builder.ebsSnapshots;
        this.expectedTimestamp = builder.expectedTimestamp;
        this.snapshotID = builder.snapshotID;
        this.sourceServerID = builder.sourceServerID;
        this.timestamp = builder.timestamp;
    }

    public final boolean hasEbsSnapshots() {
        return this.ebsSnapshots != null && !(this.ebsSnapshots instanceof SdkAutoConstructList);
    }

    public final List<String> ebsSnapshots() {
        return this.ebsSnapshots;
    }

    public final String expectedTimestamp() {
        return this.expectedTimestamp;
    }

    public final String snapshotID() {
        return this.snapshotID;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    public final String timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEbsSnapshots() ? this.ebsSnapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotID());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoverySnapshot)) {
            return false;
        }
        RecoverySnapshot other = (RecoverySnapshot)obj;
        return this.hasEbsSnapshots() == other.hasEbsSnapshots() && Objects.equals(this.ebsSnapshots(), other.ebsSnapshots()) && Objects.equals(this.expectedTimestamp(), other.expectedTimestamp()) && Objects.equals(this.snapshotID(), other.snapshotID()) && Objects.equals(this.sourceServerID(), other.sourceServerID()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"RecoverySnapshot").add("EbsSnapshots", this.hasEbsSnapshots() ? this.ebsSnapshots() : null).add("ExpectedTimestamp", (Object)this.expectedTimestamp()).add("SnapshotID", (Object)this.snapshotID()).add("SourceServerID", (Object)this.sourceServerID()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ebsSnapshots": {
                return Optional.ofNullable(clazz.cast(this.ebsSnapshots()));
            }
            case "expectedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.expectedTimestamp()));
            }
            case "snapshotID": {
                return Optional.ofNullable(clazz.cast(this.snapshotID()));
            }
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoverySnapshot, T> g) {
        return obj -> g.apply((RecoverySnapshot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> ebsSnapshots = DefaultSdkAutoConstructList.getInstance();
        private String expectedTimestamp;
        private String snapshotID;
        private String sourceServerID;
        private String timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoverySnapshot model) {
            this.ebsSnapshots(model.ebsSnapshots);
            this.expectedTimestamp(model.expectedTimestamp);
            this.snapshotID(model.snapshotID);
            this.sourceServerID(model.sourceServerID);
            this.timestamp(model.timestamp);
        }

        public final Collection<String> getEbsSnapshots() {
            if (this.ebsSnapshots instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ebsSnapshots;
        }

        public final void setEbsSnapshots(Collection<String> ebsSnapshots) {
            this.ebsSnapshots = EbsSnapshotsListCopier.copy(ebsSnapshots);
        }

        @Override
        public final Builder ebsSnapshots(Collection<String> ebsSnapshots) {
            this.ebsSnapshots = EbsSnapshotsListCopier.copy(ebsSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsSnapshots(String ... ebsSnapshots) {
            this.ebsSnapshots(Arrays.asList(ebsSnapshots));
            return this;
        }

        public final String getExpectedTimestamp() {
            return this.expectedTimestamp;
        }

        public final void setExpectedTimestamp(String expectedTimestamp) {
            this.expectedTimestamp = expectedTimestamp;
        }

        @Override
        public final Builder expectedTimestamp(String expectedTimestamp) {
            this.expectedTimestamp = expectedTimestamp;
            return this;
        }

        public final String getSnapshotID() {
            return this.snapshotID;
        }

        public final void setSnapshotID(String snapshotID) {
            this.snapshotID = snapshotID;
        }

        @Override
        public final Builder snapshotID(String snapshotID) {
            this.snapshotID = snapshotID;
            return this;
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final String getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public RecoverySnapshot build() {
            return new RecoverySnapshot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecoverySnapshot> {
        public Builder ebsSnapshots(Collection<String> var1);

        public Builder ebsSnapshots(String ... var1);

        public Builder expectedTimestamp(String var1);

        public Builder snapshotID(String var1);

        public Builder sourceServerID(String var1);

        public Builder timestamp(String var1);
    }
}

