/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExtensionStatus {
    EXTENDED("EXTENDED"),
    EXTENSION_ERROR("EXTENSION_ERROR"),
    NOT_EXTENDED("NOT_EXTENDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExtensionStatus> VALUE_MAP;
    private final String value;

    private ExtensionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExtensionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExtensionStatus> knownValues() {
        EnumSet<ExtensionStatus> knownValues = EnumSet.allOf(ExtensionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExtensionStatus.class, ExtensionStatus::toString);
    }
}

