/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing failback related information of the Recovery Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryInstanceFailback implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryInstanceFailback.Builder, RecoveryInstanceFailback> {
    private static final SdkField<String> AGENT_LAST_SEEN_BY_SERVICE_DATE_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("agentLastSeenByServiceDateTime")
            .getter(getter(RecoveryInstanceFailback::agentLastSeenByServiceDateTime))
            .setter(setter(Builder::agentLastSeenByServiceDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentLastSeenByServiceDateTime")
                    .build()).build();

    private static final SdkField<String> ELAPSED_REPLICATION_DURATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("elapsedReplicationDuration")
            .getter(getter(RecoveryInstanceFailback::elapsedReplicationDuration))
            .setter(setter(Builder::elapsedReplicationDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elapsedReplicationDuration").build())
            .build();

    private static final SdkField<String> FAILBACK_CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failbackClientID").getter(getter(RecoveryInstanceFailback::failbackClientID))
            .setter(setter(Builder::failbackClientID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failbackClientID").build()).build();

    private static final SdkField<String> FAILBACK_CLIENT_LAST_SEEN_BY_SERVICE_DATE_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("failbackClientLastSeenByServiceDateTime")
            .getter(getter(RecoveryInstanceFailback::failbackClientLastSeenByServiceDateTime))
            .setter(setter(Builder::failbackClientLastSeenByServiceDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("failbackClientLastSeenByServiceDateTime").build()).build();

    private static final SdkField<String> FAILBACK_INITIATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failbackInitiationTime").getter(getter(RecoveryInstanceFailback::failbackInitiationTime))
            .setter(setter(Builder::failbackInitiationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failbackInitiationTime").build())
            .build();

    private static final SdkField<String> FAILBACK_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failbackJobID").getter(getter(RecoveryInstanceFailback::failbackJobID))
            .setter(setter(Builder::failbackJobID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failbackJobID").build()).build();

    private static final SdkField<String> FAILBACK_LAUNCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failbackLaunchType").getter(getter(RecoveryInstanceFailback::failbackLaunchTypeAsString))
            .setter(setter(Builder::failbackLaunchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failbackLaunchType").build())
            .build();

    private static final SdkField<Boolean> FAILBACK_TO_ORIGINAL_SERVER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("failbackToOriginalServer")
            .getter(getter(RecoveryInstanceFailback::failbackToOriginalServer)).setter(setter(Builder::failbackToOriginalServer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failbackToOriginalServer").build())
            .build();

    private static final SdkField<String> FIRST_BYTE_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firstByteDateTime").getter(getter(RecoveryInstanceFailback::firstByteDateTime))
            .setter(setter(Builder::firstByteDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstByteDateTime").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(RecoveryInstanceFailback::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AGENT_LAST_SEEN_BY_SERVICE_DATE_TIME_FIELD, ELAPSED_REPLICATION_DURATION_FIELD, FAILBACK_CLIENT_ID_FIELD,
            FAILBACK_CLIENT_LAST_SEEN_BY_SERVICE_DATE_TIME_FIELD, FAILBACK_INITIATION_TIME_FIELD, FAILBACK_JOB_ID_FIELD,
            FAILBACK_LAUNCH_TYPE_FIELD, FAILBACK_TO_ORIGINAL_SERVER_FIELD, FIRST_BYTE_DATE_TIME_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentLastSeenByServiceDateTime;

    private final String elapsedReplicationDuration;

    private final String failbackClientID;

    private final String failbackClientLastSeenByServiceDateTime;

    private final String failbackInitiationTime;

    private final String failbackJobID;

    private final String failbackLaunchType;

    private final Boolean failbackToOriginalServer;

    private final String firstByteDateTime;

    private final String state;

    private RecoveryInstanceFailback(BuilderImpl builder) {
        this.agentLastSeenByServiceDateTime = builder.agentLastSeenByServiceDateTime;
        this.elapsedReplicationDuration = builder.elapsedReplicationDuration;
        this.failbackClientID = builder.failbackClientID;
        this.failbackClientLastSeenByServiceDateTime = builder.failbackClientLastSeenByServiceDateTime;
        this.failbackInitiationTime = builder.failbackInitiationTime;
        this.failbackJobID = builder.failbackJobID;
        this.failbackLaunchType = builder.failbackLaunchType;
        this.failbackToOriginalServer = builder.failbackToOriginalServer;
        this.firstByteDateTime = builder.firstByteDateTime;
        this.state = builder.state;
    }

    /**
     * <p>
     * The date and time the agent on the Recovery Instance was last seen by the service.
     * </p>
     * 
     * @return The date and time the agent on the Recovery Instance was last seen by the service.
     */
    public final String agentLastSeenByServiceDateTime() {
        return agentLastSeenByServiceDateTime;
    }

    /**
     * <p>
     * The amount of time that the Recovery Instance has been replicating for.
     * </p>
     * 
     * @return The amount of time that the Recovery Instance has been replicating for.
     */
    public final String elapsedReplicationDuration() {
        return elapsedReplicationDuration;
    }

    /**
     * <p>
     * The ID of the failback client that this Recovery Instance is associated with.
     * </p>
     * 
     * @return The ID of the failback client that this Recovery Instance is associated with.
     */
    public final String failbackClientID() {
        return failbackClientID;
    }

    /**
     * <p>
     * The date and time that the failback client was last seen by the service.
     * </p>
     * 
     * @return The date and time that the failback client was last seen by the service.
     */
    public final String failbackClientLastSeenByServiceDateTime() {
        return failbackClientLastSeenByServiceDateTime;
    }

    /**
     * <p>
     * The date and time that the failback initiation started.
     * </p>
     * 
     * @return The date and time that the failback initiation started.
     */
    public final String failbackInitiationTime() {
        return failbackInitiationTime;
    }

    /**
     * <p>
     * The Job ID of the last failback log for this Recovery Instance.
     * </p>
     * 
     * @return The Job ID of the last failback log for this Recovery Instance.
     */
    public final String failbackJobID() {
        return failbackJobID;
    }

    /**
     * <p>
     * The launch type (Recovery / Drill) of the last launch for the failback replication of this recovery instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #failbackLaunchType} will return {@link FailbackLaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #failbackLaunchTypeAsString}.
     * </p>
     * 
     * @return The launch type (Recovery / Drill) of the last launch for the failback replication of this recovery
     *         instance.
     * @see FailbackLaunchType
     */
    public final FailbackLaunchType failbackLaunchType() {
        return FailbackLaunchType.fromValue(failbackLaunchType);
    }

    /**
     * <p>
     * The launch type (Recovery / Drill) of the last launch for the failback replication of this recovery instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #failbackLaunchType} will return {@link FailbackLaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #failbackLaunchTypeAsString}.
     * </p>
     * 
     * @return The launch type (Recovery / Drill) of the last launch for the failback replication of this recovery
     *         instance.
     * @see FailbackLaunchType
     */
    public final String failbackLaunchTypeAsString() {
        return failbackLaunchType;
    }

    /**
     * <p>
     * Whether we are failing back to the original Source Server for this Recovery Instance.
     * </p>
     * 
     * @return Whether we are failing back to the original Source Server for this Recovery Instance.
     */
    public final Boolean failbackToOriginalServer() {
        return failbackToOriginalServer;
    }

    /**
     * <p>
     * The date and time of the first byte that was replicated from the Recovery Instance.
     * </p>
     * 
     * @return The date and time of the first byte that was replicated from the Recovery Instance.
     */
    public final String firstByteDateTime() {
        return firstByteDateTime;
    }

    /**
     * <p>
     * The state of the failback process that this Recovery Instance is in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link FailbackState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the failback process that this Recovery Instance is in.
     * @see FailbackState
     */
    public final FailbackState state() {
        return FailbackState.fromValue(state);
    }

    /**
     * <p>
     * The state of the failback process that this Recovery Instance is in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link FailbackState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the failback process that this Recovery Instance is in.
     * @see FailbackState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentLastSeenByServiceDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(elapsedReplicationDuration());
        hashCode = 31 * hashCode + Objects.hashCode(failbackClientID());
        hashCode = 31 * hashCode + Objects.hashCode(failbackClientLastSeenByServiceDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(failbackInitiationTime());
        hashCode = 31 * hashCode + Objects.hashCode(failbackJobID());
        hashCode = 31 * hashCode + Objects.hashCode(failbackLaunchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failbackToOriginalServer());
        hashCode = 31 * hashCode + Objects.hashCode(firstByteDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryInstanceFailback)) {
            return false;
        }
        RecoveryInstanceFailback other = (RecoveryInstanceFailback) obj;
        return Objects.equals(agentLastSeenByServiceDateTime(), other.agentLastSeenByServiceDateTime())
                && Objects.equals(elapsedReplicationDuration(), other.elapsedReplicationDuration())
                && Objects.equals(failbackClientID(), other.failbackClientID())
                && Objects.equals(failbackClientLastSeenByServiceDateTime(), other.failbackClientLastSeenByServiceDateTime())
                && Objects.equals(failbackInitiationTime(), other.failbackInitiationTime())
                && Objects.equals(failbackJobID(), other.failbackJobID())
                && Objects.equals(failbackLaunchTypeAsString(), other.failbackLaunchTypeAsString())
                && Objects.equals(failbackToOriginalServer(), other.failbackToOriginalServer())
                && Objects.equals(firstByteDateTime(), other.firstByteDateTime())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryInstanceFailback")
                .add("AgentLastSeenByServiceDateTime", agentLastSeenByServiceDateTime())
                .add("ElapsedReplicationDuration", elapsedReplicationDuration()).add("FailbackClientID", failbackClientID())
                .add("FailbackClientLastSeenByServiceDateTime", failbackClientLastSeenByServiceDateTime())
                .add("FailbackInitiationTime", failbackInitiationTime()).add("FailbackJobID", failbackJobID())
                .add("FailbackLaunchType", failbackLaunchTypeAsString())
                .add("FailbackToOriginalServer", failbackToOriginalServer()).add("FirstByteDateTime", firstByteDateTime())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentLastSeenByServiceDateTime":
            return Optional.ofNullable(clazz.cast(agentLastSeenByServiceDateTime()));
        case "elapsedReplicationDuration":
            return Optional.ofNullable(clazz.cast(elapsedReplicationDuration()));
        case "failbackClientID":
            return Optional.ofNullable(clazz.cast(failbackClientID()));
        case "failbackClientLastSeenByServiceDateTime":
            return Optional.ofNullable(clazz.cast(failbackClientLastSeenByServiceDateTime()));
        case "failbackInitiationTime":
            return Optional.ofNullable(clazz.cast(failbackInitiationTime()));
        case "failbackJobID":
            return Optional.ofNullable(clazz.cast(failbackJobID()));
        case "failbackLaunchType":
            return Optional.ofNullable(clazz.cast(failbackLaunchTypeAsString()));
        case "failbackToOriginalServer":
            return Optional.ofNullable(clazz.cast(failbackToOriginalServer()));
        case "firstByteDateTime":
            return Optional.ofNullable(clazz.cast(firstByteDateTime()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryInstanceFailback, T> g) {
        return obj -> g.apply((RecoveryInstanceFailback) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryInstanceFailback> {
        /**
         * <p>
         * The date and time the agent on the Recovery Instance was last seen by the service.
         * </p>
         * 
         * @param agentLastSeenByServiceDateTime
         *        The date and time the agent on the Recovery Instance was last seen by the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentLastSeenByServiceDateTime(String agentLastSeenByServiceDateTime);

        /**
         * <p>
         * The amount of time that the Recovery Instance has been replicating for.
         * </p>
         * 
         * @param elapsedReplicationDuration
         *        The amount of time that the Recovery Instance has been replicating for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedReplicationDuration(String elapsedReplicationDuration);

        /**
         * <p>
         * The ID of the failback client that this Recovery Instance is associated with.
         * </p>
         * 
         * @param failbackClientID
         *        The ID of the failback client that this Recovery Instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failbackClientID(String failbackClientID);

        /**
         * <p>
         * The date and time that the failback client was last seen by the service.
         * </p>
         * 
         * @param failbackClientLastSeenByServiceDateTime
         *        The date and time that the failback client was last seen by the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failbackClientLastSeenByServiceDateTime(String failbackClientLastSeenByServiceDateTime);

        /**
         * <p>
         * The date and time that the failback initiation started.
         * </p>
         * 
         * @param failbackInitiationTime
         *        The date and time that the failback initiation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failbackInitiationTime(String failbackInitiationTime);

        /**
         * <p>
         * The Job ID of the last failback log for this Recovery Instance.
         * </p>
         * 
         * @param failbackJobID
         *        The Job ID of the last failback log for this Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failbackJobID(String failbackJobID);

        /**
         * <p>
         * The launch type (Recovery / Drill) of the last launch for the failback replication of this recovery instance.
         * </p>
         * 
         * @param failbackLaunchType
         *        The launch type (Recovery / Drill) of the last launch for the failback replication of this recovery
         *        instance.
         * @see FailbackLaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailbackLaunchType
         */
        Builder failbackLaunchType(String failbackLaunchType);

        /**
         * <p>
         * The launch type (Recovery / Drill) of the last launch for the failback replication of this recovery instance.
         * </p>
         * 
         * @param failbackLaunchType
         *        The launch type (Recovery / Drill) of the last launch for the failback replication of this recovery
         *        instance.
         * @see FailbackLaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailbackLaunchType
         */
        Builder failbackLaunchType(FailbackLaunchType failbackLaunchType);

        /**
         * <p>
         * Whether we are failing back to the original Source Server for this Recovery Instance.
         * </p>
         * 
         * @param failbackToOriginalServer
         *        Whether we are failing back to the original Source Server for this Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failbackToOriginalServer(Boolean failbackToOriginalServer);

        /**
         * <p>
         * The date and time of the first byte that was replicated from the Recovery Instance.
         * </p>
         * 
         * @param firstByteDateTime
         *        The date and time of the first byte that was replicated from the Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstByteDateTime(String firstByteDateTime);

        /**
         * <p>
         * The state of the failback process that this Recovery Instance is in.
         * </p>
         * 
         * @param state
         *        The state of the failback process that this Recovery Instance is in.
         * @see FailbackState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailbackState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the failback process that this Recovery Instance is in.
         * </p>
         * 
         * @param state
         *        The state of the failback process that this Recovery Instance is in.
         * @see FailbackState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailbackState
         */
        Builder state(FailbackState state);
    }

    static final class BuilderImpl implements Builder {
        private String agentLastSeenByServiceDateTime;

        private String elapsedReplicationDuration;

        private String failbackClientID;

        private String failbackClientLastSeenByServiceDateTime;

        private String failbackInitiationTime;

        private String failbackJobID;

        private String failbackLaunchType;

        private Boolean failbackToOriginalServer;

        private String firstByteDateTime;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryInstanceFailback model) {
            agentLastSeenByServiceDateTime(model.agentLastSeenByServiceDateTime);
            elapsedReplicationDuration(model.elapsedReplicationDuration);
            failbackClientID(model.failbackClientID);
            failbackClientLastSeenByServiceDateTime(model.failbackClientLastSeenByServiceDateTime);
            failbackInitiationTime(model.failbackInitiationTime);
            failbackJobID(model.failbackJobID);
            failbackLaunchType(model.failbackLaunchType);
            failbackToOriginalServer(model.failbackToOriginalServer);
            firstByteDateTime(model.firstByteDateTime);
            state(model.state);
        }

        public final String getAgentLastSeenByServiceDateTime() {
            return agentLastSeenByServiceDateTime;
        }

        public final void setAgentLastSeenByServiceDateTime(String agentLastSeenByServiceDateTime) {
            this.agentLastSeenByServiceDateTime = agentLastSeenByServiceDateTime;
        }

        @Override
        public final Builder agentLastSeenByServiceDateTime(String agentLastSeenByServiceDateTime) {
            this.agentLastSeenByServiceDateTime = agentLastSeenByServiceDateTime;
            return this;
        }

        public final String getElapsedReplicationDuration() {
            return elapsedReplicationDuration;
        }

        public final void setElapsedReplicationDuration(String elapsedReplicationDuration) {
            this.elapsedReplicationDuration = elapsedReplicationDuration;
        }

        @Override
        public final Builder elapsedReplicationDuration(String elapsedReplicationDuration) {
            this.elapsedReplicationDuration = elapsedReplicationDuration;
            return this;
        }

        public final String getFailbackClientID() {
            return failbackClientID;
        }

        public final void setFailbackClientID(String failbackClientID) {
            this.failbackClientID = failbackClientID;
        }

        @Override
        public final Builder failbackClientID(String failbackClientID) {
            this.failbackClientID = failbackClientID;
            return this;
        }

        public final String getFailbackClientLastSeenByServiceDateTime() {
            return failbackClientLastSeenByServiceDateTime;
        }

        public final void setFailbackClientLastSeenByServiceDateTime(String failbackClientLastSeenByServiceDateTime) {
            this.failbackClientLastSeenByServiceDateTime = failbackClientLastSeenByServiceDateTime;
        }

        @Override
        public final Builder failbackClientLastSeenByServiceDateTime(String failbackClientLastSeenByServiceDateTime) {
            this.failbackClientLastSeenByServiceDateTime = failbackClientLastSeenByServiceDateTime;
            return this;
        }

        public final String getFailbackInitiationTime() {
            return failbackInitiationTime;
        }

        public final void setFailbackInitiationTime(String failbackInitiationTime) {
            this.failbackInitiationTime = failbackInitiationTime;
        }

        @Override
        public final Builder failbackInitiationTime(String failbackInitiationTime) {
            this.failbackInitiationTime = failbackInitiationTime;
            return this;
        }

        public final String getFailbackJobID() {
            return failbackJobID;
        }

        public final void setFailbackJobID(String failbackJobID) {
            this.failbackJobID = failbackJobID;
        }

        @Override
        public final Builder failbackJobID(String failbackJobID) {
            this.failbackJobID = failbackJobID;
            return this;
        }

        public final String getFailbackLaunchType() {
            return failbackLaunchType;
        }

        public final void setFailbackLaunchType(String failbackLaunchType) {
            this.failbackLaunchType = failbackLaunchType;
        }

        @Override
        public final Builder failbackLaunchType(String failbackLaunchType) {
            this.failbackLaunchType = failbackLaunchType;
            return this;
        }

        @Override
        public final Builder failbackLaunchType(FailbackLaunchType failbackLaunchType) {
            this.failbackLaunchType(failbackLaunchType == null ? null : failbackLaunchType.toString());
            return this;
        }

        public final Boolean getFailbackToOriginalServer() {
            return failbackToOriginalServer;
        }

        public final void setFailbackToOriginalServer(Boolean failbackToOriginalServer) {
            this.failbackToOriginalServer = failbackToOriginalServer;
        }

        @Override
        public final Builder failbackToOriginalServer(Boolean failbackToOriginalServer) {
            this.failbackToOriginalServer = failbackToOriginalServer;
            return this;
        }

        public final String getFirstByteDateTime() {
            return firstByteDateTime;
        }

        public final void setFirstByteDateTime(String firstByteDateTime) {
            this.firstByteDateTime = firstByteDateTime;
        }

        @Override
        public final Builder firstByteDateTime(String firstByteDateTime) {
            this.firstByteDateTime = firstByteDateTime;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(FailbackState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public RecoveryInstanceFailback build() {
            return new RecoveryInstanceFailback(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
