/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLaunchConfigurationRequest extends DrsRequest implements
        ToCopyableBuilder<UpdateLaunchConfigurationRequest.Builder, UpdateLaunchConfigurationRequest> {
    private static final SdkField<Boolean> COPY_PRIVATE_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("copyPrivateIp").getter(getter(UpdateLaunchConfigurationRequest::copyPrivateIp))
            .setter(setter(Builder::copyPrivateIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyPrivateIp").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("copyTags").getter(getter(UpdateLaunchConfigurationRequest::copyTags)).setter(setter(Builder::copyTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTags").build()).build();

    private static final SdkField<String> LAUNCH_DISPOSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchDisposition").getter(getter(UpdateLaunchConfigurationRequest::launchDispositionAsString))
            .setter(setter(Builder::launchDisposition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDisposition").build()).build();

    private static final SdkField<Licensing> LICENSING_FIELD = SdkField.<Licensing> builder(MarshallingType.SDK_POJO)
            .memberName("licensing").getter(getter(UpdateLaunchConfigurationRequest::licensing))
            .setter(setter(Builder::licensing)).constructor(Licensing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licensing").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateLaunchConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(UpdateLaunchConfigurationRequest::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final SdkField<String> TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("targetInstanceTypeRightSizingMethod")
            .getter(getter(UpdateLaunchConfigurationRequest::targetInstanceTypeRightSizingMethodAsString))
            .setter(setter(Builder::targetInstanceTypeRightSizingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("targetInstanceTypeRightSizingMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_PRIVATE_IP_FIELD,
            COPY_TAGS_FIELD, LAUNCH_DISPOSITION_FIELD, LICENSING_FIELD, NAME_FIELD, SOURCE_SERVER_ID_FIELD,
            TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD));

    private final Boolean copyPrivateIp;

    private final Boolean copyTags;

    private final String launchDisposition;

    private final Licensing licensing;

    private final String name;

    private final String sourceServerID;

    private final String targetInstanceTypeRightSizingMethod;

    private UpdateLaunchConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.copyPrivateIp = builder.copyPrivateIp;
        this.copyTags = builder.copyTags;
        this.launchDisposition = builder.launchDisposition;
        this.licensing = builder.licensing;
        this.name = builder.name;
        this.sourceServerID = builder.sourceServerID;
        this.targetInstanceTypeRightSizingMethod = builder.targetInstanceTypeRightSizingMethod;
    }

    /**
     * <p>
     * Whether we should copy the Private IP of the Source Server to the Recovery Instance.
     * </p>
     * 
     * @return Whether we should copy the Private IP of the Source Server to the Recovery Instance.
     */
    public final Boolean copyPrivateIp() {
        return copyPrivateIp;
    }

    /**
     * <p>
     * Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.
     * </p>
     * 
     * @return Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.
     */
    public final Boolean copyTags() {
        return copyTags;
    }

    /**
     * <p>
     * The state of the Recovery Instance in EC2 after the recovery operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchDisposition}
     * will return {@link LaunchDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #launchDispositionAsString}.
     * </p>
     * 
     * @return The state of the Recovery Instance in EC2 after the recovery operation.
     * @see LaunchDisposition
     */
    public final LaunchDisposition launchDisposition() {
        return LaunchDisposition.fromValue(launchDisposition);
    }

    /**
     * <p>
     * The state of the Recovery Instance in EC2 after the recovery operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchDisposition}
     * will return {@link LaunchDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #launchDispositionAsString}.
     * </p>
     * 
     * @return The state of the Recovery Instance in EC2 after the recovery operation.
     * @see LaunchDisposition
     */
    public final String launchDispositionAsString() {
        return launchDisposition;
    }

    /**
     * <p>
     * The licensing configuration to be used for this launch configuration.
     * </p>
     * 
     * @return The licensing configuration to be used for this launch configuration.
     */
    public final Licensing licensing() {
        return licensing;
    }

    /**
     * <p>
     * The name of the launch configuration.
     * </p>
     * 
     * @return The name of the launch configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the Source Server that we want to retrieve a Launch Configuration for.
     * </p>
     * 
     * @return The ID of the Source Server that we want to retrieve a Launch Configuration for.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    /**
     * <p>
     * Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS,
     * CPU, and RAM of your Source Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetInstanceTypeRightSizingMethod} will return
     * {@link TargetInstanceTypeRightSizingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetInstanceTypeRightSizingMethodAsString}.
     * </p>
     * 
     * @return Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches
     *         the OS, CPU, and RAM of your Source Server.
     * @see TargetInstanceTypeRightSizingMethod
     */
    public final TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod() {
        return TargetInstanceTypeRightSizingMethod.fromValue(targetInstanceTypeRightSizingMethod);
    }

    /**
     * <p>
     * Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the OS,
     * CPU, and RAM of your Source Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetInstanceTypeRightSizingMethod} will return
     * {@link TargetInstanceTypeRightSizingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetInstanceTypeRightSizingMethodAsString}.
     * </p>
     * 
     * @return Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches
     *         the OS, CPU, and RAM of your Source Server.
     * @see TargetInstanceTypeRightSizingMethod
     */
    public final String targetInstanceTypeRightSizingMethodAsString() {
        return targetInstanceTypeRightSizingMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(copyPrivateIp());
        hashCode = 31 * hashCode + Objects.hashCode(copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(launchDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licensing());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(targetInstanceTypeRightSizingMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLaunchConfigurationRequest)) {
            return false;
        }
        UpdateLaunchConfigurationRequest other = (UpdateLaunchConfigurationRequest) obj;
        return Objects.equals(copyPrivateIp(), other.copyPrivateIp())
                && Objects.equals(copyTags(), other.copyTags())
                && Objects.equals(launchDispositionAsString(), other.launchDispositionAsString())
                && Objects.equals(licensing(), other.licensing())
                && Objects.equals(name(), other.name())
                && Objects.equals(sourceServerID(), other.sourceServerID())
                && Objects.equals(targetInstanceTypeRightSizingMethodAsString(),
                        other.targetInstanceTypeRightSizingMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLaunchConfigurationRequest").add("CopyPrivateIp", copyPrivateIp())
                .add("CopyTags", copyTags()).add("LaunchDisposition", launchDispositionAsString()).add("Licensing", licensing())
                .add("Name", name()).add("SourceServerID", sourceServerID())
                .add("TargetInstanceTypeRightSizingMethod", targetInstanceTypeRightSizingMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "copyPrivateIp":
            return Optional.ofNullable(clazz.cast(copyPrivateIp()));
        case "copyTags":
            return Optional.ofNullable(clazz.cast(copyTags()));
        case "launchDisposition":
            return Optional.ofNullable(clazz.cast(launchDispositionAsString()));
        case "licensing":
            return Optional.ofNullable(clazz.cast(licensing()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        case "targetInstanceTypeRightSizingMethod":
            return Optional.ofNullable(clazz.cast(targetInstanceTypeRightSizingMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLaunchConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateLaunchConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLaunchConfigurationRequest> {
        /**
         * <p>
         * Whether we should copy the Private IP of the Source Server to the Recovery Instance.
         * </p>
         * 
         * @param copyPrivateIp
         *        Whether we should copy the Private IP of the Source Server to the Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyPrivateIp(Boolean copyPrivateIp);

        /**
         * <p>
         * Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.
         * </p>
         * 
         * @param copyTags
         *        Whether we want to copy the tags of the Source Server to the EC2 machine of the Recovery Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTags(Boolean copyTags);

        /**
         * <p>
         * The state of the Recovery Instance in EC2 after the recovery operation.
         * </p>
         * 
         * @param launchDisposition
         *        The state of the Recovery Instance in EC2 after the recovery operation.
         * @see LaunchDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchDisposition
         */
        Builder launchDisposition(String launchDisposition);

        /**
         * <p>
         * The state of the Recovery Instance in EC2 after the recovery operation.
         * </p>
         * 
         * @param launchDisposition
         *        The state of the Recovery Instance in EC2 after the recovery operation.
         * @see LaunchDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchDisposition
         */
        Builder launchDisposition(LaunchDisposition launchDisposition);

        /**
         * <p>
         * The licensing configuration to be used for this launch configuration.
         * </p>
         * 
         * @param licensing
         *        The licensing configuration to be used for this launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licensing(Licensing licensing);

        /**
         * <p>
         * The licensing configuration to be used for this launch configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link Licensing.Builder} avoiding the need to
         * create one manually via {@link Licensing#builder()}.
         *
         * When the {@link Consumer} completes, {@link Licensing.Builder#build()} is called immediately and its result
         * is passed to {@link #licensing(Licensing)}.
         * 
         * @param licensing
         *        a consumer that will call methods on {@link Licensing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licensing(Licensing)
         */
        default Builder licensing(Consumer<Licensing.Builder> licensing) {
            return licensing(Licensing.builder().applyMutation(licensing).build());
        }

        /**
         * <p>
         * The name of the launch configuration.
         * </p>
         * 
         * @param name
         *        The name of the launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the Source Server that we want to retrieve a Launch Configuration for.
         * </p>
         * 
         * @param sourceServerID
         *        The ID of the Source Server that we want to retrieve a Launch Configuration for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        /**
         * <p>
         * Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the
         * OS, CPU, and RAM of your Source Server.
         * </p>
         * 
         * @param targetInstanceTypeRightSizingMethod
         *        Whether Elastic Disaster Recovery should try to automatically choose the instance type that best
         *        matches the OS, CPU, and RAM of your Source Server.
         * @see TargetInstanceTypeRightSizingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetInstanceTypeRightSizingMethod
         */
        Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod);

        /**
         * <p>
         * Whether Elastic Disaster Recovery should try to automatically choose the instance type that best matches the
         * OS, CPU, and RAM of your Source Server.
         * </p>
         * 
         * @param targetInstanceTypeRightSizingMethod
         *        Whether Elastic Disaster Recovery should try to automatically choose the instance type that best
         *        matches the OS, CPU, and RAM of your Source Server.
         * @see TargetInstanceTypeRightSizingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetInstanceTypeRightSizingMethod
         */
        Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DrsRequest.BuilderImpl implements Builder {
        private Boolean copyPrivateIp;

        private Boolean copyTags;

        private String launchDisposition;

        private Licensing licensing;

        private String name;

        private String sourceServerID;

        private String targetInstanceTypeRightSizingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLaunchConfigurationRequest model) {
            super(model);
            copyPrivateIp(model.copyPrivateIp);
            copyTags(model.copyTags);
            launchDisposition(model.launchDisposition);
            licensing(model.licensing);
            name(model.name);
            sourceServerID(model.sourceServerID);
            targetInstanceTypeRightSizingMethod(model.targetInstanceTypeRightSizingMethod);
        }

        public final Boolean getCopyPrivateIp() {
            return copyPrivateIp;
        }

        public final void setCopyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
        }

        @Override
        public final Builder copyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
            return this;
        }

        public final Boolean getCopyTags() {
            return copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final String getLaunchDisposition() {
            return launchDisposition;
        }

        public final void setLaunchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
        }

        @Override
        public final Builder launchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
            return this;
        }

        @Override
        public final Builder launchDisposition(LaunchDisposition launchDisposition) {
            this.launchDisposition(launchDisposition == null ? null : launchDisposition.toString());
            return this;
        }

        public final Licensing.Builder getLicensing() {
            return licensing != null ? licensing.toBuilder() : null;
        }

        public final void setLicensing(Licensing.BuilderImpl licensing) {
            this.licensing = licensing != null ? licensing.build() : null;
        }

        @Override
        public final Builder licensing(Licensing licensing) {
            this.licensing = licensing;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final String getTargetInstanceTypeRightSizingMethod() {
            return targetInstanceTypeRightSizingMethod;
        }

        public final void setTargetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
            return this;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(
                TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod(targetInstanceTypeRightSizingMethod == null ? null
                    : targetInstanceTypeRightSizingMethod.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLaunchConfigurationRequest build() {
            return new UpdateLaunchConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
