/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceServer implements SdkPojo, Serializable, ToCopyableBuilder<SourceServer.Builder, SourceServer> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SourceServer::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<DataReplicationInfo> DATA_REPLICATION_INFO_FIELD = SdkField
            .<DataReplicationInfo> builder(MarshallingType.SDK_POJO).memberName("dataReplicationInfo")
            .getter(getter(SourceServer::dataReplicationInfo)).setter(setter(Builder::dataReplicationInfo))
            .constructor(DataReplicationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInfo").build())
            .build();

    private static final SdkField<String> LAST_LAUNCH_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastLaunchResult").getter(getter(SourceServer::lastLaunchResultAsString))
            .setter(setter(Builder::lastLaunchResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastLaunchResult").build()).build();

    private static final SdkField<LifeCycle> LIFE_CYCLE_FIELD = SdkField.<LifeCycle> builder(MarshallingType.SDK_POJO)
            .memberName("lifeCycle").getter(getter(SourceServer::lifeCycle)).setter(setter(Builder::lifeCycle))
            .constructor(LifeCycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifeCycle").build()).build();

    private static final SdkField<String> RECOVERY_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recoveryInstanceId").getter(getter(SourceServer::recoveryInstanceId))
            .setter(setter(Builder::recoveryInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryInstanceId").build())
            .build();

    private static final SdkField<SourceProperties> SOURCE_PROPERTIES_FIELD = SdkField
            .<SourceProperties> builder(MarshallingType.SDK_POJO).memberName("sourceProperties")
            .getter(getter(SourceServer::sourceProperties)).setter(setter(Builder::sourceProperties))
            .constructor(SourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceProperties").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(SourceServer::sourceServerID)).setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SourceServer::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            DATA_REPLICATION_INFO_FIELD, LAST_LAUNCH_RESULT_FIELD, LIFE_CYCLE_FIELD, RECOVERY_INSTANCE_ID_FIELD,
            SOURCE_PROPERTIES_FIELD, SOURCE_SERVER_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final DataReplicationInfo dataReplicationInfo;

    private final String lastLaunchResult;

    private final LifeCycle lifeCycle;

    private final String recoveryInstanceId;

    private final SourceProperties sourceProperties;

    private final String sourceServerID;

    private final Map<String, String> tags;

    private SourceServer(BuilderImpl builder) {
        this.arn = builder.arn;
        this.dataReplicationInfo = builder.dataReplicationInfo;
        this.lastLaunchResult = builder.lastLaunchResult;
        this.lifeCycle = builder.lifeCycle;
        this.recoveryInstanceId = builder.recoveryInstanceId;
        this.sourceProperties = builder.sourceProperties;
        this.sourceServerID = builder.sourceServerID;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the Source Server.
     * </p>
     * 
     * @return The ARN of the Source Server.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Data Replication Info of the Source Server.
     * </p>
     * 
     * @return The Data Replication Info of the Source Server.
     */
    public final DataReplicationInfo dataReplicationInfo() {
        return dataReplicationInfo;
    }

    /**
     * <p>
     * The status of the last recovery launch of this Source Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastLaunchResult}
     * will return {@link LastLaunchResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lastLaunchResultAsString}.
     * </p>
     * 
     * @return The status of the last recovery launch of this Source Server.
     * @see LastLaunchResult
     */
    public final LastLaunchResult lastLaunchResult() {
        return LastLaunchResult.fromValue(lastLaunchResult);
    }

    /**
     * <p>
     * The status of the last recovery launch of this Source Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastLaunchResult}
     * will return {@link LastLaunchResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lastLaunchResultAsString}.
     * </p>
     * 
     * @return The status of the last recovery launch of this Source Server.
     * @see LastLaunchResult
     */
    public final String lastLaunchResultAsString() {
        return lastLaunchResult;
    }

    /**
     * <p>
     * The lifecycle information of this Source Server.
     * </p>
     * 
     * @return The lifecycle information of this Source Server.
     */
    public final LifeCycle lifeCycle() {
        return lifeCycle;
    }

    /**
     * <p>
     * The ID of the Recovery Instance associated with this Source Server.
     * </p>
     * 
     * @return The ID of the Recovery Instance associated with this Source Server.
     */
    public final String recoveryInstanceId() {
        return recoveryInstanceId;
    }

    /**
     * <p>
     * The source properties of the Source Server.
     * </p>
     * 
     * @return The source properties of the Source Server.
     */
    public final SourceProperties sourceProperties() {
        return sourceProperties;
    }

    /**
     * <p>
     * The ID of the Source Server.
     * </p>
     * 
     * @return The ID of the Source Server.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the Source Server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the Source Server.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(lastLaunchResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceServer)) {
            return false;
        }
        SourceServer other = (SourceServer) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(dataReplicationInfo(), other.dataReplicationInfo())
                && Objects.equals(lastLaunchResultAsString(), other.lastLaunchResultAsString())
                && Objects.equals(lifeCycle(), other.lifeCycle())
                && Objects.equals(recoveryInstanceId(), other.recoveryInstanceId())
                && Objects.equals(sourceProperties(), other.sourceProperties())
                && Objects.equals(sourceServerID(), other.sourceServerID()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceServer").add("Arn", arn()).add("DataReplicationInfo", dataReplicationInfo())
                .add("LastLaunchResult", lastLaunchResultAsString()).add("LifeCycle", lifeCycle())
                .add("RecoveryInstanceId", recoveryInstanceId()).add("SourceProperties", sourceProperties())
                .add("SourceServerID", sourceServerID()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "dataReplicationInfo":
            return Optional.ofNullable(clazz.cast(dataReplicationInfo()));
        case "lastLaunchResult":
            return Optional.ofNullable(clazz.cast(lastLaunchResultAsString()));
        case "lifeCycle":
            return Optional.ofNullable(clazz.cast(lifeCycle()));
        case "recoveryInstanceId":
            return Optional.ofNullable(clazz.cast(recoveryInstanceId()));
        case "sourceProperties":
            return Optional.ofNullable(clazz.cast(sourceProperties()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceServer, T> g) {
        return obj -> g.apply((SourceServer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceServer> {
        /**
         * <p>
         * The ARN of the Source Server.
         * </p>
         * 
         * @param arn
         *        The ARN of the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Data Replication Info of the Source Server.
         * </p>
         * 
         * @param dataReplicationInfo
         *        The Data Replication Info of the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationInfo(DataReplicationInfo dataReplicationInfo);

        /**
         * <p>
         * The Data Replication Info of the Source Server.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataReplicationInfo.Builder} avoiding the
         * need to create one manually via {@link DataReplicationInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataReplicationInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #dataReplicationInfo(DataReplicationInfo)}.
         * 
         * @param dataReplicationInfo
         *        a consumer that will call methods on {@link DataReplicationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataReplicationInfo(DataReplicationInfo)
         */
        default Builder dataReplicationInfo(Consumer<DataReplicationInfo.Builder> dataReplicationInfo) {
            return dataReplicationInfo(DataReplicationInfo.builder().applyMutation(dataReplicationInfo).build());
        }

        /**
         * <p>
         * The status of the last recovery launch of this Source Server.
         * </p>
         * 
         * @param lastLaunchResult
         *        The status of the last recovery launch of this Source Server.
         * @see LastLaunchResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastLaunchResult
         */
        Builder lastLaunchResult(String lastLaunchResult);

        /**
         * <p>
         * The status of the last recovery launch of this Source Server.
         * </p>
         * 
         * @param lastLaunchResult
         *        The status of the last recovery launch of this Source Server.
         * @see LastLaunchResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastLaunchResult
         */
        Builder lastLaunchResult(LastLaunchResult lastLaunchResult);

        /**
         * <p>
         * The lifecycle information of this Source Server.
         * </p>
         * 
         * @param lifeCycle
         *        The lifecycle information of this Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycle(LifeCycle lifeCycle);

        /**
         * <p>
         * The lifecycle information of this Source Server.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifeCycle.Builder} avoiding the need to
         * create one manually via {@link LifeCycle#builder()}.
         *
         * When the {@link Consumer} completes, {@link LifeCycle.Builder#build()} is called immediately and its result
         * is passed to {@link #lifeCycle(LifeCycle)}.
         * 
         * @param lifeCycle
         *        a consumer that will call methods on {@link LifeCycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifeCycle(LifeCycle)
         */
        default Builder lifeCycle(Consumer<LifeCycle.Builder> lifeCycle) {
            return lifeCycle(LifeCycle.builder().applyMutation(lifeCycle).build());
        }

        /**
         * <p>
         * The ID of the Recovery Instance associated with this Source Server.
         * </p>
         * 
         * @param recoveryInstanceId
         *        The ID of the Recovery Instance associated with this Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryInstanceId(String recoveryInstanceId);

        /**
         * <p>
         * The source properties of the Source Server.
         * </p>
         * 
         * @param sourceProperties
         *        The source properties of the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceProperties(SourceProperties sourceProperties);

        /**
         * <p>
         * The source properties of the Source Server.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceProperties.Builder} avoiding the
         * need to create one manually via {@link SourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceProperties(SourceProperties)}.
         * 
         * @param sourceProperties
         *        a consumer that will call methods on {@link SourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceProperties(SourceProperties)
         */
        default Builder sourceProperties(Consumer<SourceProperties.Builder> sourceProperties) {
            return sourceProperties(SourceProperties.builder().applyMutation(sourceProperties).build());
        }

        /**
         * <p>
         * The ID of the Source Server.
         * </p>
         * 
         * @param sourceServerID
         *        The ID of the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        /**
         * <p>
         * The tags associated with the Source Server.
         * </p>
         * 
         * @param tags
         *        The tags associated with the Source Server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private DataReplicationInfo dataReplicationInfo;

        private String lastLaunchResult;

        private LifeCycle lifeCycle;

        private String recoveryInstanceId;

        private SourceProperties sourceProperties;

        private String sourceServerID;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceServer model) {
            arn(model.arn);
            dataReplicationInfo(model.dataReplicationInfo);
            lastLaunchResult(model.lastLaunchResult);
            lifeCycle(model.lifeCycle);
            recoveryInstanceId(model.recoveryInstanceId);
            sourceProperties(model.sourceProperties);
            sourceServerID(model.sourceServerID);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final DataReplicationInfo.Builder getDataReplicationInfo() {
            return dataReplicationInfo != null ? dataReplicationInfo.toBuilder() : null;
        }

        public final void setDataReplicationInfo(DataReplicationInfo.BuilderImpl dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo != null ? dataReplicationInfo.build() : null;
        }

        @Override
        public final Builder dataReplicationInfo(DataReplicationInfo dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo;
            return this;
        }

        public final String getLastLaunchResult() {
            return lastLaunchResult;
        }

        public final void setLastLaunchResult(String lastLaunchResult) {
            this.lastLaunchResult = lastLaunchResult;
        }

        @Override
        public final Builder lastLaunchResult(String lastLaunchResult) {
            this.lastLaunchResult = lastLaunchResult;
            return this;
        }

        @Override
        public final Builder lastLaunchResult(LastLaunchResult lastLaunchResult) {
            this.lastLaunchResult(lastLaunchResult == null ? null : lastLaunchResult.toString());
            return this;
        }

        public final LifeCycle.Builder getLifeCycle() {
            return lifeCycle != null ? lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(LifeCycle.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(LifeCycle lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final String getRecoveryInstanceId() {
            return recoveryInstanceId;
        }

        public final void setRecoveryInstanceId(String recoveryInstanceId) {
            this.recoveryInstanceId = recoveryInstanceId;
        }

        @Override
        public final Builder recoveryInstanceId(String recoveryInstanceId) {
            this.recoveryInstanceId = recoveryInstanceId;
            return this;
        }

        public final SourceProperties.Builder getSourceProperties() {
            return sourceProperties != null ? sourceProperties.toBuilder() : null;
        }

        public final void setSourceProperties(SourceProperties.BuilderImpl sourceProperties) {
            this.sourceProperties = sourceProperties != null ? sourceProperties.build() : null;
        }

        @Override
        public final Builder sourceProperties(SourceProperties sourceProperties) {
            this.sourceProperties = sourceProperties;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public SourceServer build() {
            return new SourceServer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
