/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about Data Replication
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryInstanceDataReplicationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryInstanceDataReplicationInfo.Builder, RecoveryInstanceDataReplicationInfo> {
    private static final SdkField<RecoveryInstanceDataReplicationError> DATA_REPLICATION_ERROR_FIELD = SdkField
            .<RecoveryInstanceDataReplicationError> builder(MarshallingType.SDK_POJO).memberName("dataReplicationError")
            .getter(getter(RecoveryInstanceDataReplicationInfo::dataReplicationError))
            .setter(setter(Builder::dataReplicationError)).constructor(RecoveryInstanceDataReplicationError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationError").build())
            .build();

    private static final SdkField<RecoveryInstanceDataReplicationInitiation> DATA_REPLICATION_INITIATION_FIELD = SdkField
            .<RecoveryInstanceDataReplicationInitiation> builder(MarshallingType.SDK_POJO)
            .memberName("dataReplicationInitiation")
            .getter(getter(RecoveryInstanceDataReplicationInfo::dataReplicationInitiation))
            .setter(setter(Builder::dataReplicationInitiation)).constructor(RecoveryInstanceDataReplicationInitiation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInitiation").build())
            .build();

    private static final SdkField<String> DATA_REPLICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataReplicationState").getter(getter(RecoveryInstanceDataReplicationInfo::dataReplicationStateAsString))
            .setter(setter(Builder::dataReplicationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationState").build())
            .build();

    private static final SdkField<String> ETA_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("etaDateTime").getter(getter(RecoveryInstanceDataReplicationInfo::etaDateTime))
            .setter(setter(Builder::etaDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etaDateTime").build()).build();

    private static final SdkField<String> LAG_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lagDuration").getter(getter(RecoveryInstanceDataReplicationInfo::lagDuration))
            .setter(setter(Builder::lagDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagDuration").build()).build();

    private static final SdkField<List<RecoveryInstanceDataReplicationInfoReplicatedDisk>> REPLICATED_DISKS_FIELD = SdkField
            .<List<RecoveryInstanceDataReplicationInfoReplicatedDisk>> builder(MarshallingType.LIST)
            .memberName("replicatedDisks")
            .getter(getter(RecoveryInstanceDataReplicationInfo::replicatedDisks))
            .setter(setter(Builder::replicatedDisks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatedDisks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecoveryInstanceDataReplicationInfoReplicatedDisk> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecoveryInstanceDataReplicationInfoReplicatedDisk::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_REPLICATION_ERROR_FIELD,
            DATA_REPLICATION_INITIATION_FIELD, DATA_REPLICATION_STATE_FIELD, ETA_DATE_TIME_FIELD, LAG_DURATION_FIELD,
            REPLICATED_DISKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final RecoveryInstanceDataReplicationError dataReplicationError;

    private final RecoveryInstanceDataReplicationInitiation dataReplicationInitiation;

    private final String dataReplicationState;

    private final String etaDateTime;

    private final String lagDuration;

    private final List<RecoveryInstanceDataReplicationInfoReplicatedDisk> replicatedDisks;

    private RecoveryInstanceDataReplicationInfo(BuilderImpl builder) {
        this.dataReplicationError = builder.dataReplicationError;
        this.dataReplicationInitiation = builder.dataReplicationInitiation;
        this.dataReplicationState = builder.dataReplicationState;
        this.etaDateTime = builder.etaDateTime;
        this.lagDuration = builder.lagDuration;
        this.replicatedDisks = builder.replicatedDisks;
    }

    /**
     * <p>
     * Information about Data Replication
     * </p>
     * 
     * @return Information about Data Replication
     */
    public final RecoveryInstanceDataReplicationError dataReplicationError() {
        return dataReplicationError;
    }

    /**
     * <p>
     * Information about whether the data replication has been initiated.
     * </p>
     * 
     * @return Information about whether the data replication has been initiated.
     */
    public final RecoveryInstanceDataReplicationInitiation dataReplicationInitiation() {
        return dataReplicationInitiation;
    }

    /**
     * <p>
     * The state of the data replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataReplicationState} will return {@link RecoveryInstanceDataReplicationState#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dataReplicationStateAsString}.
     * </p>
     * 
     * @return The state of the data replication.
     * @see RecoveryInstanceDataReplicationState
     */
    public final RecoveryInstanceDataReplicationState dataReplicationState() {
        return RecoveryInstanceDataReplicationState.fromValue(dataReplicationState);
    }

    /**
     * <p>
     * The state of the data replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataReplicationState} will return {@link RecoveryInstanceDataReplicationState#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dataReplicationStateAsString}.
     * </p>
     * 
     * @return The state of the data replication.
     * @see RecoveryInstanceDataReplicationState
     */
    public final String dataReplicationStateAsString() {
        return dataReplicationState;
    }

    /**
     * <p>
     * An estimate of when the data replication will be completed.
     * </p>
     * 
     * @return An estimate of when the data replication will be completed.
     */
    public final String etaDateTime() {
        return etaDateTime;
    }

    /**
     * <p>
     * Data replication lag duration.
     * </p>
     * 
     * @return Data replication lag duration.
     */
    public final String lagDuration() {
        return lagDuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicatedDisks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicatedDisks() {
        return replicatedDisks != null && !(replicatedDisks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The disks that should be replicated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicatedDisks} method.
     * </p>
     * 
     * @return The disks that should be replicated.
     */
    public final List<RecoveryInstanceDataReplicationInfoReplicatedDisk> replicatedDisks() {
        return replicatedDisks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationError());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationInitiation());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(etaDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lagDuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicatedDisks() ? replicatedDisks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryInstanceDataReplicationInfo)) {
            return false;
        }
        RecoveryInstanceDataReplicationInfo other = (RecoveryInstanceDataReplicationInfo) obj;
        return Objects.equals(dataReplicationError(), other.dataReplicationError())
                && Objects.equals(dataReplicationInitiation(), other.dataReplicationInitiation())
                && Objects.equals(dataReplicationStateAsString(), other.dataReplicationStateAsString())
                && Objects.equals(etaDateTime(), other.etaDateTime()) && Objects.equals(lagDuration(), other.lagDuration())
                && hasReplicatedDisks() == other.hasReplicatedDisks()
                && Objects.equals(replicatedDisks(), other.replicatedDisks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryInstanceDataReplicationInfo").add("DataReplicationError", dataReplicationError())
                .add("DataReplicationInitiation", dataReplicationInitiation())
                .add("DataReplicationState", dataReplicationStateAsString()).add("EtaDateTime", etaDateTime())
                .add("LagDuration", lagDuration()).add("ReplicatedDisks", hasReplicatedDisks() ? replicatedDisks() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataReplicationError":
            return Optional.ofNullable(clazz.cast(dataReplicationError()));
        case "dataReplicationInitiation":
            return Optional.ofNullable(clazz.cast(dataReplicationInitiation()));
        case "dataReplicationState":
            return Optional.ofNullable(clazz.cast(dataReplicationStateAsString()));
        case "etaDateTime":
            return Optional.ofNullable(clazz.cast(etaDateTime()));
        case "lagDuration":
            return Optional.ofNullable(clazz.cast(lagDuration()));
        case "replicatedDisks":
            return Optional.ofNullable(clazz.cast(replicatedDisks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryInstanceDataReplicationInfo, T> g) {
        return obj -> g.apply((RecoveryInstanceDataReplicationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryInstanceDataReplicationInfo> {
        /**
         * <p>
         * Information about Data Replication
         * </p>
         * 
         * @param dataReplicationError
         *        Information about Data Replication
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationError(RecoveryInstanceDataReplicationError dataReplicationError);

        /**
         * <p>
         * Information about Data Replication
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RecoveryInstanceDataReplicationError.Builder} avoiding the need to create one manually via
         * {@link RecoveryInstanceDataReplicationError#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecoveryInstanceDataReplicationError.Builder#build()} is called
         * immediately and its result is passed to {@link #dataReplicationError(RecoveryInstanceDataReplicationError)}.
         * 
         * @param dataReplicationError
         *        a consumer that will call methods on {@link RecoveryInstanceDataReplicationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataReplicationError(RecoveryInstanceDataReplicationError)
         */
        default Builder dataReplicationError(Consumer<RecoveryInstanceDataReplicationError.Builder> dataReplicationError) {
            return dataReplicationError(RecoveryInstanceDataReplicationError.builder().applyMutation(dataReplicationError)
                    .build());
        }

        /**
         * <p>
         * Information about whether the data replication has been initiated.
         * </p>
         * 
         * @param dataReplicationInitiation
         *        Information about whether the data replication has been initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationInitiation(RecoveryInstanceDataReplicationInitiation dataReplicationInitiation);

        /**
         * <p>
         * Information about whether the data replication has been initiated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RecoveryInstanceDataReplicationInitiation.Builder} avoiding the need to create one manually via
         * {@link RecoveryInstanceDataReplicationInitiation#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecoveryInstanceDataReplicationInitiation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #dataReplicationInitiation(RecoveryInstanceDataReplicationInitiation)}.
         * 
         * @param dataReplicationInitiation
         *        a consumer that will call methods on {@link RecoveryInstanceDataReplicationInitiation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataReplicationInitiation(RecoveryInstanceDataReplicationInitiation)
         */
        default Builder dataReplicationInitiation(
                Consumer<RecoveryInstanceDataReplicationInitiation.Builder> dataReplicationInitiation) {
            return dataReplicationInitiation(RecoveryInstanceDataReplicationInitiation.builder()
                    .applyMutation(dataReplicationInitiation).build());
        }

        /**
         * <p>
         * The state of the data replication.
         * </p>
         * 
         * @param dataReplicationState
         *        The state of the data replication.
         * @see RecoveryInstanceDataReplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryInstanceDataReplicationState
         */
        Builder dataReplicationState(String dataReplicationState);

        /**
         * <p>
         * The state of the data replication.
         * </p>
         * 
         * @param dataReplicationState
         *        The state of the data replication.
         * @see RecoveryInstanceDataReplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryInstanceDataReplicationState
         */
        Builder dataReplicationState(RecoveryInstanceDataReplicationState dataReplicationState);

        /**
         * <p>
         * An estimate of when the data replication will be completed.
         * </p>
         * 
         * @param etaDateTime
         *        An estimate of when the data replication will be completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder etaDateTime(String etaDateTime);

        /**
         * <p>
         * Data replication lag duration.
         * </p>
         * 
         * @param lagDuration
         *        Data replication lag duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lagDuration(String lagDuration);

        /**
         * <p>
         * The disks that should be replicated.
         * </p>
         * 
         * @param replicatedDisks
         *        The disks that should be replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatedDisks(Collection<RecoveryInstanceDataReplicationInfoReplicatedDisk> replicatedDisks);

        /**
         * <p>
         * The disks that should be replicated.
         * </p>
         * 
         * @param replicatedDisks
         *        The disks that should be replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatedDisks(RecoveryInstanceDataReplicationInfoReplicatedDisk... replicatedDisks);

        /**
         * <p>
         * The disks that should be replicated.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <RecoveryInstanceDataReplicationInfoReplicatedDisk>.Builder} avoiding the need to create one manually via
         * {@link List<RecoveryInstanceDataReplicationInfoReplicatedDisk>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <RecoveryInstanceDataReplicationInfoReplicatedDisk>.Builder#build()} is called immediately and its result is
         * passed to {@link #replicatedDisks(List<RecoveryInstanceDataReplicationInfoReplicatedDisk>)}.
         * 
         * @param replicatedDisks
         *        a consumer that will call methods on {@link List
         *        <RecoveryInstanceDataReplicationInfoReplicatedDisk>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicatedDisks(List<RecoveryInstanceDataReplicationInfoReplicatedDisk>)
         */
        Builder replicatedDisks(Consumer<RecoveryInstanceDataReplicationInfoReplicatedDisk.Builder>... replicatedDisks);
    }

    static final class BuilderImpl implements Builder {
        private RecoveryInstanceDataReplicationError dataReplicationError;

        private RecoveryInstanceDataReplicationInitiation dataReplicationInitiation;

        private String dataReplicationState;

        private String etaDateTime;

        private String lagDuration;

        private List<RecoveryInstanceDataReplicationInfoReplicatedDisk> replicatedDisks = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryInstanceDataReplicationInfo model) {
            dataReplicationError(model.dataReplicationError);
            dataReplicationInitiation(model.dataReplicationInitiation);
            dataReplicationState(model.dataReplicationState);
            etaDateTime(model.etaDateTime);
            lagDuration(model.lagDuration);
            replicatedDisks(model.replicatedDisks);
        }

        public final RecoveryInstanceDataReplicationError.Builder getDataReplicationError() {
            return dataReplicationError != null ? dataReplicationError.toBuilder() : null;
        }

        public final void setDataReplicationError(RecoveryInstanceDataReplicationError.BuilderImpl dataReplicationError) {
            this.dataReplicationError = dataReplicationError != null ? dataReplicationError.build() : null;
        }

        @Override
        public final Builder dataReplicationError(RecoveryInstanceDataReplicationError dataReplicationError) {
            this.dataReplicationError = dataReplicationError;
            return this;
        }

        public final RecoveryInstanceDataReplicationInitiation.Builder getDataReplicationInitiation() {
            return dataReplicationInitiation != null ? dataReplicationInitiation.toBuilder() : null;
        }

        public final void setDataReplicationInitiation(
                RecoveryInstanceDataReplicationInitiation.BuilderImpl dataReplicationInitiation) {
            this.dataReplicationInitiation = dataReplicationInitiation != null ? dataReplicationInitiation.build() : null;
        }

        @Override
        public final Builder dataReplicationInitiation(RecoveryInstanceDataReplicationInitiation dataReplicationInitiation) {
            this.dataReplicationInitiation = dataReplicationInitiation;
            return this;
        }

        public final String getDataReplicationState() {
            return dataReplicationState;
        }

        public final void setDataReplicationState(String dataReplicationState) {
            this.dataReplicationState = dataReplicationState;
        }

        @Override
        public final Builder dataReplicationState(String dataReplicationState) {
            this.dataReplicationState = dataReplicationState;
            return this;
        }

        @Override
        public final Builder dataReplicationState(RecoveryInstanceDataReplicationState dataReplicationState) {
            this.dataReplicationState(dataReplicationState == null ? null : dataReplicationState.toString());
            return this;
        }

        public final String getEtaDateTime() {
            return etaDateTime;
        }

        public final void setEtaDateTime(String etaDateTime) {
            this.etaDateTime = etaDateTime;
        }

        @Override
        public final Builder etaDateTime(String etaDateTime) {
            this.etaDateTime = etaDateTime;
            return this;
        }

        public final String getLagDuration() {
            return lagDuration;
        }

        public final void setLagDuration(String lagDuration) {
            this.lagDuration = lagDuration;
        }

        @Override
        public final Builder lagDuration(String lagDuration) {
            this.lagDuration = lagDuration;
            return this;
        }

        public final List<RecoveryInstanceDataReplicationInfoReplicatedDisk.Builder> getReplicatedDisks() {
            List<RecoveryInstanceDataReplicationInfoReplicatedDisk.Builder> result = RecoveryInstanceDataReplicationInfoReplicatedDisksCopier
                    .copyToBuilder(this.replicatedDisks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicatedDisks(
                Collection<RecoveryInstanceDataReplicationInfoReplicatedDisk.BuilderImpl> replicatedDisks) {
            this.replicatedDisks = RecoveryInstanceDataReplicationInfoReplicatedDisksCopier.copyFromBuilder(replicatedDisks);
        }

        @Override
        public final Builder replicatedDisks(Collection<RecoveryInstanceDataReplicationInfoReplicatedDisk> replicatedDisks) {
            this.replicatedDisks = RecoveryInstanceDataReplicationInfoReplicatedDisksCopier.copy(replicatedDisks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(RecoveryInstanceDataReplicationInfoReplicatedDisk... replicatedDisks) {
            replicatedDisks(Arrays.asList(replicatedDisks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(
                Consumer<RecoveryInstanceDataReplicationInfoReplicatedDisk.Builder>... replicatedDisks) {
            replicatedDisks(Stream.of(replicatedDisks)
                    .map(c -> RecoveryInstanceDataReplicationInfoReplicatedDisk.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RecoveryInstanceDataReplicationInfo build() {
            return new RecoveryInstanceDataReplicationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
