/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplicationConfigurationTemplatesResponse extends DrsResponse
        implements
        ToCopyableBuilder<DescribeReplicationConfigurationTemplatesResponse.Builder, DescribeReplicationConfigurationTemplatesResponse> {
    private static final SdkField<List<ReplicationConfigurationTemplate>> ITEMS_FIELD = SdkField
            .<List<ReplicationConfigurationTemplate>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(DescribeReplicationConfigurationTemplatesResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationConfigurationTemplate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationConfigurationTemplate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeReplicationConfigurationTemplatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ReplicationConfigurationTemplate> items;

    private final String nextToken;

    private DescribeReplicationConfigurationTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Replication Configuration Templates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return An array of Replication Configuration Templates.
     */
    public final List<ReplicationConfigurationTemplate> items() {
        return items;
    }

    /**
     * <p>
     * The token of the next Replication Configuration Template to retrieve.
     * </p>
     * 
     * @return The token of the next Replication Configuration Template to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationConfigurationTemplatesResponse)) {
            return false;
        }
        DescribeReplicationConfigurationTemplatesResponse other = (DescribeReplicationConfigurationTemplatesResponse) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReplicationConfigurationTemplatesResponse").add("Items", hasItems() ? items() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationConfigurationTemplatesResponse, T> g) {
        return obj -> g.apply((DescribeReplicationConfigurationTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReplicationConfigurationTemplatesResponse> {
        /**
         * <p>
         * An array of Replication Configuration Templates.
         * </p>
         * 
         * @param items
         *        An array of Replication Configuration Templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<ReplicationConfigurationTemplate> items);

        /**
         * <p>
         * An array of Replication Configuration Templates.
         * </p>
         * 
         * @param items
         *        An array of Replication Configuration Templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(ReplicationConfigurationTemplate... items);

        /**
         * <p>
         * An array of Replication Configuration Templates.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ReplicationConfigurationTemplate>.Builder} avoiding the need to create one manually via {@link List
         * <ReplicationConfigurationTemplate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationConfigurationTemplate>.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<ReplicationConfigurationTemplate>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<ReplicationConfigurationTemplate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<ReplicationConfigurationTemplate>)
         */
        Builder items(Consumer<ReplicationConfigurationTemplate.Builder>... items);

        /**
         * <p>
         * The token of the next Replication Configuration Template to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The token of the next Replication Configuration Template to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DrsResponse.BuilderImpl implements Builder {
        private List<ReplicationConfigurationTemplate> items = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationConfigurationTemplatesResponse model) {
            super(model);
            items(model.items);
            nextToken(model.nextToken);
        }

        public final List<ReplicationConfigurationTemplate.Builder> getItems() {
            List<ReplicationConfigurationTemplate.Builder> result = ReplicationConfigurationTemplatesCopier
                    .copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ReplicationConfigurationTemplate.BuilderImpl> items) {
            this.items = ReplicationConfigurationTemplatesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<ReplicationConfigurationTemplate> items) {
            this.items = ReplicationConfigurationTemplatesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ReplicationConfigurationTemplate... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ReplicationConfigurationTemplate.Builder>... items) {
            items(Stream.of(items).map(c -> ReplicationConfigurationTemplate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeReplicationConfigurationTemplatesResponse build() {
            return new DescribeReplicationConfigurationTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
