/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRecoverySnapshotsRequest extends DrsRequest implements
        ToCopyableBuilder<DescribeRecoverySnapshotsRequest.Builder, DescribeRecoverySnapshotsRequest> {
    private static final SdkField<DescribeRecoverySnapshotsRequestFilters> FILTERS_FIELD = SdkField
            .<DescribeRecoverySnapshotsRequestFilters> builder(MarshallingType.SDK_POJO).memberName("filters")
            .getter(getter(DescribeRecoverySnapshotsRequest::filters)).setter(setter(Builder::filters))
            .constructor(DescribeRecoverySnapshotsRequestFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeRecoverySnapshotsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeRecoverySnapshotsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("order")
            .getter(getter(DescribeRecoverySnapshotsRequest::orderAsString)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(DescribeRecoverySnapshotsRequest::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORDER_FIELD, SOURCE_SERVER_ID_FIELD));

    private final DescribeRecoverySnapshotsRequestFilters filters;

    private final Integer maxResults;

    private final String nextToken;

    private final String order;

    private final String sourceServerID;

    private DescribeRecoverySnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.order = builder.order;
        this.sourceServerID = builder.sourceServerID;
    }

    /**
     * <p>
     * A set of filters by which to return Recovery Snapshots.
     * </p>
     * 
     * @return A set of filters by which to return Recovery Snapshots.
     */
    public final DescribeRecoverySnapshotsRequestFilters filters() {
        return filters;
    }

    /**
     * <p>
     * Maximum number of Recovery Snapshots to retrieve.
     * </p>
     * 
     * @return Maximum number of Recovery Snapshots to retrieve.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token of the next Recovery Snapshot to retrieve.
     * </p>
     * 
     * @return The token of the next Recovery Snapshot to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The sorted ordering by which to return Recovery Snapshots.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link RecoverySnapshotsOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return The sorted ordering by which to return Recovery Snapshots.
     * @see RecoverySnapshotsOrder
     */
    public final RecoverySnapshotsOrder order() {
        return RecoverySnapshotsOrder.fromValue(order);
    }

    /**
     * <p>
     * The sorted ordering by which to return Recovery Snapshots.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link RecoverySnapshotsOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return The sorted ordering by which to return Recovery Snapshots.
     * @see RecoverySnapshotsOrder
     */
    public final String orderAsString() {
        return order;
    }

    /**
     * <p>
     * Filter Recovery Snapshots by Source Server ID.
     * </p>
     * 
     * @return Filter Recovery Snapshots by Source Server ID.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(orderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecoverySnapshotsRequest)) {
            return false;
        }
        DescribeRecoverySnapshotsRequest other = (DescribeRecoverySnapshotsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(orderAsString(), other.orderAsString())
                && Objects.equals(sourceServerID(), other.sourceServerID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRecoverySnapshotsRequest").add("Filters", filters()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Order", orderAsString()).add("SourceServerID", sourceServerID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "order":
            return Optional.ofNullable(clazz.cast(orderAsString()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecoverySnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeRecoverySnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DrsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRecoverySnapshotsRequest> {
        /**
         * <p>
         * A set of filters by which to return Recovery Snapshots.
         * </p>
         * 
         * @param filters
         *        A set of filters by which to return Recovery Snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(DescribeRecoverySnapshotsRequestFilters filters);

        /**
         * <p>
         * A set of filters by which to return Recovery Snapshots.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DescribeRecoverySnapshotsRequestFilters.Builder} avoiding the need to create one manually via
         * {@link DescribeRecoverySnapshotsRequestFilters#builder()}.
         *
         * When the {@link Consumer} completes, {@link DescribeRecoverySnapshotsRequestFilters.Builder#build()} is
         * called immediately and its result is passed to {@link #filters(DescribeRecoverySnapshotsRequestFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link DescribeRecoverySnapshotsRequestFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(DescribeRecoverySnapshotsRequestFilters)
         */
        default Builder filters(Consumer<DescribeRecoverySnapshotsRequestFilters.Builder> filters) {
            return filters(DescribeRecoverySnapshotsRequestFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * Maximum number of Recovery Snapshots to retrieve.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of Recovery Snapshots to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token of the next Recovery Snapshot to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The token of the next Recovery Snapshot to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The sorted ordering by which to return Recovery Snapshots.
         * </p>
         * 
         * @param order
         *        The sorted ordering by which to return Recovery Snapshots.
         * @see RecoverySnapshotsOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoverySnapshotsOrder
         */
        Builder order(String order);

        /**
         * <p>
         * The sorted ordering by which to return Recovery Snapshots.
         * </p>
         * 
         * @param order
         *        The sorted ordering by which to return Recovery Snapshots.
         * @see RecoverySnapshotsOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoverySnapshotsOrder
         */
        Builder order(RecoverySnapshotsOrder order);

        /**
         * <p>
         * Filter Recovery Snapshots by Source Server ID.
         * </p>
         * 
         * @param sourceServerID
         *        Filter Recovery Snapshots by Source Server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DrsRequest.BuilderImpl implements Builder {
        private DescribeRecoverySnapshotsRequestFilters filters;

        private Integer maxResults;

        private String nextToken;

        private String order;

        private String sourceServerID;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecoverySnapshotsRequest model) {
            super(model);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            order(model.order);
            sourceServerID(model.sourceServerID);
        }

        public final DescribeRecoverySnapshotsRequestFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(DescribeRecoverySnapshotsRequestFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(DescribeRecoverySnapshotsRequestFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOrder() {
            return order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(RecoverySnapshotsOrder order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRecoverySnapshotsRequest build() {
            return new DescribeRecoverySnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
