/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLifecyclePoliciesRequest extends DlmRequest implements
        ToCopyableBuilder<GetLifecyclePoliciesRequest.Builder, GetLifecyclePoliciesRequest> {
    private static final SdkField<List<String>> POLICY_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PolicyIds")
            .getter(getter(GetLifecyclePoliciesRequest::policyIds))
            .setter(setter(Builder::policyIds))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("policyIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(GetLifecyclePoliciesRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state").build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(GetLifecyclePoliciesRequest::resourceTypesAsStrings))
            .setter(setter(Builder::resourceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TARGET_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetTags")
            .getter(getter(GetLifecyclePoliciesRequest::targetTags))
            .setter(setter(Builder::targetTags))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TAGS_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagsToAdd")
            .getter(getter(GetLifecyclePoliciesRequest::tagsToAdd))
            .setter(setter(Builder::tagsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("tagsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultPolicyType").getter(getter(GetLifecyclePoliciesRequest::defaultPolicyTypeAsString))
            .setter(setter(Builder::defaultPolicyType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("defaultPolicyType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_IDS_FIELD, STATE_FIELD,
            RESOURCE_TYPES_FIELD, TARGET_TAGS_FIELD, TAGS_TO_ADD_FIELD, DEFAULT_POLICY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> policyIds;

    private final String state;

    private final List<String> resourceTypes;

    private final List<String> targetTags;

    private final List<String> tagsToAdd;

    private final String defaultPolicyType;

    private GetLifecyclePoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.policyIds = builder.policyIds;
        this.state = builder.state;
        this.resourceTypes = builder.resourceTypes;
        this.targetTags = builder.targetTags;
        this.tagsToAdd = builder.tagsToAdd;
        this.defaultPolicyType = builder.defaultPolicyType;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolicyIds() {
        return policyIds != null && !(policyIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the data lifecycle policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyIds} method.
     * </p>
     * 
     * @return The identifiers of the data lifecycle policies.
     */
    public final List<String> policyIds() {
        return policyIds;
    }

    /**
     * <p>
     * The activation state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link GettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The activation state.
     * @see GettablePolicyStateValues
     */
    public final GettablePolicyStateValues state() {
        return GettablePolicyStateValues.fromValue(state);
    }

    /**
     * <p>
     * The activation state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link GettablePolicyStateValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The activation state.
     * @see GettablePolicyStateValues
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The resource type.
     */
    public final List<ResourceTypeValues> resourceTypes() {
        return ResourceTypeValuesListCopier.copyStringToEnum(resourceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The resource type.
     */
    public final List<String> resourceTypesAsStrings() {
        return resourceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargetTags() {
        return targetTags != null && !(targetTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target tag for a policy.
     * </p>
     * <p>
     * Tags are strings in the format <code>key=value</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetTags} method.
     * </p>
     * 
     * @return The target tag for a policy.</p>
     *         <p>
     *         Tags are strings in the format <code>key=value</code>.
     */
    public final List<String> targetTags() {
        return targetTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagsToAdd property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagsToAdd() {
        return tagsToAdd != null && !(tagsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to add to objects created by the policy.
     * </p>
     * <p>
     * Tags are strings in the format <code>key=value</code>.
     * </p>
     * <p>
     * These user-defined tags are added in addition to the Amazon Web Services-added lifecycle tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagsToAdd} method.
     * </p>
     * 
     * @return The tags to add to objects created by the policy.</p>
     *         <p>
     *         Tags are strings in the format <code>key=value</code>.
     *         </p>
     *         <p>
     *         These user-defined tags are added in addition to the Amazon Web Services-added lifecycle tags.
     */
    public final List<String> tagsToAdd() {
        return tagsToAdd;
    }

    /**
     * <p>
     * <b>[Default policies only]</b> Specifies the type of default policy to get. Specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>VOLUME</code> - To get only the default policy for EBS snapshots
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE</code> - To get only the default policy for EBS-backed AMIs
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - To get all default policies
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultPolicyType}
     * will return {@link DefaultPoliciesTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultPolicyTypeAsString}.
     * </p>
     * 
     * @return <b>[Default policies only]</b> Specifies the type of default policy to get. Specify one of the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VOLUME</code> - To get only the default policy for EBS snapshots
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTANCE</code> - To get only the default policy for EBS-backed AMIs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - To get all default policies
     *         </p>
     *         </li>
     * @see DefaultPoliciesTypeValues
     */
    public final DefaultPoliciesTypeValues defaultPolicyType() {
        return DefaultPoliciesTypeValues.fromValue(defaultPolicyType);
    }

    /**
     * <p>
     * <b>[Default policies only]</b> Specifies the type of default policy to get. Specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>VOLUME</code> - To get only the default policy for EBS snapshots
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSTANCE</code> - To get only the default policy for EBS-backed AMIs
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - To get all default policies
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultPolicyType}
     * will return {@link DefaultPoliciesTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultPolicyTypeAsString}.
     * </p>
     * 
     * @return <b>[Default policies only]</b> Specifies the type of default policy to get. Specify one of the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VOLUME</code> - To get only the default policy for EBS snapshots
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSTANCE</code> - To get only the default policy for EBS-backed AMIs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - To get all default policies
     *         </p>
     *         </li>
     * @see DefaultPoliciesTypeValues
     */
    public final String defaultPolicyTypeAsString() {
        return defaultPolicyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyIds() ? policyIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetTags() ? targetTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagsToAdd() ? tagsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultPolicyTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePoliciesRequest)) {
            return false;
        }
        GetLifecyclePoliciesRequest other = (GetLifecyclePoliciesRequest) obj;
        return hasPolicyIds() == other.hasPolicyIds() && Objects.equals(policyIds(), other.policyIds())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasResourceTypes() == other.hasResourceTypes()
                && Objects.equals(resourceTypesAsStrings(), other.resourceTypesAsStrings())
                && hasTargetTags() == other.hasTargetTags() && Objects.equals(targetTags(), other.targetTags())
                && hasTagsToAdd() == other.hasTagsToAdd() && Objects.equals(tagsToAdd(), other.tagsToAdd())
                && Objects.equals(defaultPolicyTypeAsString(), other.defaultPolicyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLifecyclePoliciesRequest").add("PolicyIds", hasPolicyIds() ? policyIds() : null)
                .add("State", stateAsString()).add("ResourceTypes", hasResourceTypes() ? resourceTypesAsStrings() : null)
                .add("TargetTags", hasTargetTags() ? targetTags() : null).add("TagsToAdd", hasTagsToAdd() ? tagsToAdd() : null)
                .add("DefaultPolicyType", defaultPolicyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyIds":
            return Optional.ofNullable(clazz.cast(policyIds()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypesAsStrings()));
        case "TargetTags":
            return Optional.ofNullable(clazz.cast(targetTags()));
        case "TagsToAdd":
            return Optional.ofNullable(clazz.cast(tagsToAdd()));
        case "DefaultPolicyType":
            return Optional.ofNullable(clazz.cast(defaultPolicyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyIds", POLICY_IDS_FIELD);
        map.put("state", STATE_FIELD);
        map.put("resourceTypes", RESOURCE_TYPES_FIELD);
        map.put("targetTags", TARGET_TAGS_FIELD);
        map.put("tagsToAdd", TAGS_TO_ADD_FIELD);
        map.put("defaultPolicyType", DEFAULT_POLICY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLifecyclePoliciesRequest, T> g) {
        return obj -> g.apply((GetLifecyclePoliciesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DlmRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetLifecyclePoliciesRequest> {
        /**
         * <p>
         * The identifiers of the data lifecycle policies.
         * </p>
         * 
         * @param policyIds
         *        The identifiers of the data lifecycle policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyIds(Collection<String> policyIds);

        /**
         * <p>
         * The identifiers of the data lifecycle policies.
         * </p>
         * 
         * @param policyIds
         *        The identifiers of the data lifecycle policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyIds(String... policyIds);

        /**
         * <p>
         * The activation state.
         * </p>
         * 
         * @param state
         *        The activation state.
         * @see GettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GettablePolicyStateValues
         */
        Builder state(String state);

        /**
         * <p>
         * The activation state.
         * </p>
         * 
         * @param state
         *        The activation state.
         * @see GettablePolicyStateValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GettablePolicyStateValues
         */
        Builder state(GettablePolicyStateValues state);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceTypes
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(Collection<String> resourceTypes);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceTypes
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(String... resourceTypes);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceTypes
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<ResourceTypeValues> resourceTypes);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceTypes
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(ResourceTypeValues... resourceTypes);

        /**
         * <p>
         * The target tag for a policy.
         * </p>
         * <p>
         * Tags are strings in the format <code>key=value</code>.
         * </p>
         * 
         * @param targetTags
         *        The target tag for a policy.</p>
         *        <p>
         *        Tags are strings in the format <code>key=value</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTags(Collection<String> targetTags);

        /**
         * <p>
         * The target tag for a policy.
         * </p>
         * <p>
         * Tags are strings in the format <code>key=value</code>.
         * </p>
         * 
         * @param targetTags
         *        The target tag for a policy.</p>
         *        <p>
         *        Tags are strings in the format <code>key=value</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTags(String... targetTags);

        /**
         * <p>
         * The tags to add to objects created by the policy.
         * </p>
         * <p>
         * Tags are strings in the format <code>key=value</code>.
         * </p>
         * <p>
         * These user-defined tags are added in addition to the Amazon Web Services-added lifecycle tags.
         * </p>
         * 
         * @param tagsToAdd
         *        The tags to add to objects created by the policy.</p>
         *        <p>
         *        Tags are strings in the format <code>key=value</code>.
         *        </p>
         *        <p>
         *        These user-defined tags are added in addition to the Amazon Web Services-added lifecycle tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToAdd(Collection<String> tagsToAdd);

        /**
         * <p>
         * The tags to add to objects created by the policy.
         * </p>
         * <p>
         * Tags are strings in the format <code>key=value</code>.
         * </p>
         * <p>
         * These user-defined tags are added in addition to the Amazon Web Services-added lifecycle tags.
         * </p>
         * 
         * @param tagsToAdd
         *        The tags to add to objects created by the policy.</p>
         *        <p>
         *        Tags are strings in the format <code>key=value</code>.
         *        </p>
         *        <p>
         *        These user-defined tags are added in addition to the Amazon Web Services-added lifecycle tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToAdd(String... tagsToAdd);

        /**
         * <p>
         * <b>[Default policies only]</b> Specifies the type of default policy to get. Specify one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>VOLUME</code> - To get only the default policy for EBS snapshots
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE</code> - To get only the default policy for EBS-backed AMIs
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - To get all default policies
         * </p>
         * </li>
         * </ul>
         * 
         * @param defaultPolicyType
         *        <b>[Default policies only]</b> Specifies the type of default policy to get. Specify one of the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VOLUME</code> - To get only the default policy for EBS snapshots
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTANCE</code> - To get only the default policy for EBS-backed AMIs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - To get all default policies
         *        </p>
         *        </li>
         * @see DefaultPoliciesTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultPoliciesTypeValues
         */
        Builder defaultPolicyType(String defaultPolicyType);

        /**
         * <p>
         * <b>[Default policies only]</b> Specifies the type of default policy to get. Specify one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>VOLUME</code> - To get only the default policy for EBS snapshots
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSTANCE</code> - To get only the default policy for EBS-backed AMIs
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - To get all default policies
         * </p>
         * </li>
         * </ul>
         * 
         * @param defaultPolicyType
         *        <b>[Default policies only]</b> Specifies the type of default policy to get. Specify one of the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VOLUME</code> - To get only the default policy for EBS snapshots
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSTANCE</code> - To get only the default policy for EBS-backed AMIs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - To get all default policies
         *        </p>
         *        </li>
         * @see DefaultPoliciesTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultPoliciesTypeValues
         */
        Builder defaultPolicyType(DefaultPoliciesTypeValues defaultPolicyType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DlmRequest.BuilderImpl implements Builder {
        private List<String> policyIds = DefaultSdkAutoConstructList.getInstance();

        private String state;

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> targetTags = DefaultSdkAutoConstructList.getInstance();

        private List<String> tagsToAdd = DefaultSdkAutoConstructList.getInstance();

        private String defaultPolicyType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePoliciesRequest model) {
            super(model);
            policyIds(model.policyIds);
            state(model.state);
            resourceTypesWithStrings(model.resourceTypes);
            targetTags(model.targetTags);
            tagsToAdd(model.tagsToAdd);
            defaultPolicyType(model.defaultPolicyType);
        }

        public final Collection<String> getPolicyIds() {
            if (policyIds instanceof SdkAutoConstructList) {
                return null;
            }
            return policyIds;
        }

        public final void setPolicyIds(Collection<String> policyIds) {
            this.policyIds = PolicyIdListCopier.copy(policyIds);
        }

        @Override
        public final Builder policyIds(Collection<String> policyIds) {
            this.policyIds = PolicyIdListCopier.copy(policyIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyIds(String... policyIds) {
            policyIds(Arrays.asList(policyIds));
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(GettablePolicyStateValues state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String... resourceTypes) {
            resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceTypeValues> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceTypeValues... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Collection<String> getTargetTags() {
            if (targetTags instanceof SdkAutoConstructList) {
                return null;
            }
            return targetTags;
        }

        public final void setTargetTags(Collection<String> targetTags) {
            this.targetTags = TargetTagsFilterListCopier.copy(targetTags);
        }

        @Override
        public final Builder targetTags(Collection<String> targetTags) {
            this.targetTags = TargetTagsFilterListCopier.copy(targetTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTags(String... targetTags) {
            targetTags(Arrays.asList(targetTags));
            return this;
        }

        public final Collection<String> getTagsToAdd() {
            if (tagsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return tagsToAdd;
        }

        public final void setTagsToAdd(Collection<String> tagsToAdd) {
            this.tagsToAdd = TagsToAddFilterListCopier.copy(tagsToAdd);
        }

        @Override
        public final Builder tagsToAdd(Collection<String> tagsToAdd) {
            this.tagsToAdd = TagsToAddFilterListCopier.copy(tagsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToAdd(String... tagsToAdd) {
            tagsToAdd(Arrays.asList(tagsToAdd));
            return this;
        }

        public final String getDefaultPolicyType() {
            return defaultPolicyType;
        }

        public final void setDefaultPolicyType(String defaultPolicyType) {
            this.defaultPolicyType = defaultPolicyType;
        }

        @Override
        public final Builder defaultPolicyType(String defaultPolicyType) {
            this.defaultPolicyType = defaultPolicyType;
            return this;
        }

        @Override
        public final Builder defaultPolicyType(DefaultPoliciesTypeValues defaultPolicyType) {
            this.defaultPolicyType(defaultPolicyType == null ? null : defaultPolicyType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLifecyclePoliciesRequest build() {
            return new GetLifecyclePoliciesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
