/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dlm.model.CrossRegionCopyTarget;
import software.amazon.awssdk.services.dlm.model.CrossRegionCopyTargetListCopier;
import software.amazon.awssdk.services.dlm.model.DefaultPolicyTypeValues;
import software.amazon.awssdk.services.dlm.model.DlmRequest;
import software.amazon.awssdk.services.dlm.model.Exclusions;
import software.amazon.awssdk.services.dlm.model.PolicyDetails;
import software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues;
import software.amazon.awssdk.services.dlm.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLifecyclePolicyRequest
extends DlmRequest
implements ToCopyableBuilder<Builder, CreateLifecyclePolicyRequest> {
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::executionRoleArn)).setter(CreateLifecyclePolicyRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::description)).setter(CreateLifecyclePolicyRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::stateAsString)).setter(CreateLifecyclePolicyRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<PolicyDetails> POLICY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PolicyDetails").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::policyDetails)).setter(CreateLifecyclePolicyRequest.setter(Builder::policyDetails)).constructor(PolicyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDetails").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::tags)).setter(CreateLifecyclePolicyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultPolicy").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::defaultPolicyAsString)).setter(CreateLifecyclePolicyRequest.setter(Builder::defaultPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultPolicy").build()}).build();
    private static final SdkField<Integer> CREATE_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CreateInterval").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::createInterval)).setter(CreateLifecyclePolicyRequest.setter(Builder::createInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateInterval").build()}).build();
    private static final SdkField<Integer> RETAIN_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetainInterval").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::retainInterval)).setter(CreateLifecyclePolicyRequest.setter(Builder::retainInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainInterval").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTags").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::copyTags)).setter(CreateLifecyclePolicyRequest.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()}).build();
    private static final SdkField<Boolean> EXTEND_DELETION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExtendDeletion").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::extendDeletion)).setter(CreateLifecyclePolicyRequest.setter(Builder::extendDeletion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendDeletion").build()}).build();
    private static final SdkField<List<CrossRegionCopyTarget>> CROSS_REGION_COPY_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CrossRegionCopyTargets").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::crossRegionCopyTargets)).setter(CreateLifecyclePolicyRequest.setter(Builder::crossRegionCopyTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossRegionCopyTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CrossRegionCopyTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Exclusions> EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Exclusions").getter(CreateLifecyclePolicyRequest.getter(CreateLifecyclePolicyRequest::exclusions)).setter(CreateLifecyclePolicyRequest.setter(Builder::exclusions)).constructor(Exclusions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclusions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_ARN_FIELD, DESCRIPTION_FIELD, STATE_FIELD, POLICY_DETAILS_FIELD, TAGS_FIELD, DEFAULT_POLICY_FIELD, CREATE_INTERVAL_FIELD, RETAIN_INTERVAL_FIELD, COPY_TAGS_FIELD, EXTEND_DELETION_FIELD, CROSS_REGION_COPY_TARGETS_FIELD, EXCLUSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLifecyclePolicyRequest.memberNameToFieldInitializer();
    private final String executionRoleArn;
    private final String description;
    private final String state;
    private final PolicyDetails policyDetails;
    private final Map<String, String> tags;
    private final String defaultPolicy;
    private final Integer createInterval;
    private final Integer retainInterval;
    private final Boolean copyTags;
    private final Boolean extendDeletion;
    private final List<CrossRegionCopyTarget> crossRegionCopyTargets;
    private final Exclusions exclusions;

    private CreateLifecyclePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.executionRoleArn = builder.executionRoleArn;
        this.description = builder.description;
        this.state = builder.state;
        this.policyDetails = builder.policyDetails;
        this.tags = builder.tags;
        this.defaultPolicy = builder.defaultPolicy;
        this.createInterval = builder.createInterval;
        this.retainInterval = builder.retainInterval;
        this.copyTags = builder.copyTags;
        this.extendDeletion = builder.extendDeletion;
        this.crossRegionCopyTargets = builder.crossRegionCopyTargets;
        this.exclusions = builder.exclusions;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String description() {
        return this.description;
    }

    public final SettablePolicyStateValues state() {
        return SettablePolicyStateValues.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final PolicyDetails policyDetails() {
        return this.policyDetails;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final DefaultPolicyTypeValues defaultPolicy() {
        return DefaultPolicyTypeValues.fromValue(this.defaultPolicy);
    }

    public final String defaultPolicyAsString() {
        return this.defaultPolicy;
    }

    public final Integer createInterval() {
        return this.createInterval;
    }

    public final Integer retainInterval() {
        return this.retainInterval;
    }

    public final Boolean copyTags() {
        return this.copyTags;
    }

    public final Boolean extendDeletion() {
        return this.extendDeletion;
    }

    public final boolean hasCrossRegionCopyTargets() {
        return this.crossRegionCopyTargets != null && !(this.crossRegionCopyTargets instanceof SdkAutoConstructList);
    }

    public final List<CrossRegionCopyTarget> crossRegionCopyTargets() {
        return this.crossRegionCopyTargets;
    }

    public final Exclusions exclusions() {
        return this.exclusions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendDeletion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrossRegionCopyTargets() ? this.crossRegionCopyTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLifecyclePolicyRequest)) {
            return false;
        }
        CreateLifecyclePolicyRequest other = (CreateLifecyclePolicyRequest)((Object)obj);
        return Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.policyDetails(), other.policyDetails()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.defaultPolicyAsString(), other.defaultPolicyAsString()) && Objects.equals(this.createInterval(), other.createInterval()) && Objects.equals(this.retainInterval(), other.retainInterval()) && Objects.equals(this.copyTags(), other.copyTags()) && Objects.equals(this.extendDeletion(), other.extendDeletion()) && this.hasCrossRegionCopyTargets() == other.hasCrossRegionCopyTargets() && Objects.equals(this.crossRegionCopyTargets(), other.crossRegionCopyTargets()) && Objects.equals(this.exclusions(), other.exclusions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLifecyclePolicyRequest").add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("Description", (Object)this.description()).add("State", (Object)this.stateAsString()).add("PolicyDetails", (Object)this.policyDetails()).add("Tags", this.hasTags() ? this.tags() : null).add("DefaultPolicy", (Object)this.defaultPolicyAsString()).add("CreateInterval", (Object)this.createInterval()).add("RetainInterval", (Object)this.retainInterval()).add("CopyTags", (Object)this.copyTags()).add("ExtendDeletion", (Object)this.extendDeletion()).add("CrossRegionCopyTargets", this.hasCrossRegionCopyTargets() ? this.crossRegionCopyTargets() : null).add("Exclusions", (Object)this.exclusions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "PolicyDetails": {
                return Optional.ofNullable(clazz.cast(this.policyDetails()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DefaultPolicy": {
                return Optional.ofNullable(clazz.cast(this.defaultPolicyAsString()));
            }
            case "CreateInterval": {
                return Optional.ofNullable(clazz.cast(this.createInterval()));
            }
            case "RetainInterval": {
                return Optional.ofNullable(clazz.cast(this.retainInterval()));
            }
            case "CopyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "ExtendDeletion": {
                return Optional.ofNullable(clazz.cast(this.extendDeletion()));
            }
            case "CrossRegionCopyTargets": {
                return Optional.ofNullable(clazz.cast(this.crossRegionCopyTargets()));
            }
            case "Exclusions": {
                return Optional.ofNullable(clazz.cast(this.exclusions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("PolicyDetails", POLICY_DETAILS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("DefaultPolicy", DEFAULT_POLICY_FIELD);
        map.put("CreateInterval", CREATE_INTERVAL_FIELD);
        map.put("RetainInterval", RETAIN_INTERVAL_FIELD);
        map.put("CopyTags", COPY_TAGS_FIELD);
        map.put("ExtendDeletion", EXTEND_DELETION_FIELD);
        map.put("CrossRegionCopyTargets", CROSS_REGION_COPY_TARGETS_FIELD);
        map.put("Exclusions", EXCLUSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLifecyclePolicyRequest, T> g) {
        return obj -> g.apply((CreateLifecyclePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DlmRequest.BuilderImpl
    implements Builder {
        private String executionRoleArn;
        private String description;
        private String state;
        private PolicyDetails policyDetails;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String defaultPolicy;
        private Integer createInterval;
        private Integer retainInterval;
        private Boolean copyTags;
        private Boolean extendDeletion;
        private List<CrossRegionCopyTarget> crossRegionCopyTargets = DefaultSdkAutoConstructList.getInstance();
        private Exclusions exclusions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLifecyclePolicyRequest model) {
            super(model);
            this.executionRoleArn(model.executionRoleArn);
            this.description(model.description);
            this.state(model.state);
            this.policyDetails(model.policyDetails);
            this.tags(model.tags);
            this.defaultPolicy(model.defaultPolicy);
            this.createInterval(model.createInterval);
            this.retainInterval(model.retainInterval);
            this.copyTags(model.copyTags);
            this.extendDeletion(model.extendDeletion);
            this.crossRegionCopyTargets(model.crossRegionCopyTargets);
            this.exclusions(model.exclusions);
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SettablePolicyStateValues state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final PolicyDetails.Builder getPolicyDetails() {
            return this.policyDetails != null ? this.policyDetails.toBuilder() : null;
        }

        public final void setPolicyDetails(PolicyDetails.BuilderImpl policyDetails) {
            this.policyDetails = policyDetails != null ? policyDetails.build() : null;
        }

        @Override
        public final Builder policyDetails(PolicyDetails policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getDefaultPolicy() {
            return this.defaultPolicy;
        }

        public final void setDefaultPolicy(String defaultPolicy) {
            this.defaultPolicy = defaultPolicy;
        }

        @Override
        public final Builder defaultPolicy(String defaultPolicy) {
            this.defaultPolicy = defaultPolicy;
            return this;
        }

        @Override
        public final Builder defaultPolicy(DefaultPolicyTypeValues defaultPolicy) {
            this.defaultPolicy(defaultPolicy == null ? null : defaultPolicy.toString());
            return this;
        }

        public final Integer getCreateInterval() {
            return this.createInterval;
        }

        public final void setCreateInterval(Integer createInterval) {
            this.createInterval = createInterval;
        }

        @Override
        public final Builder createInterval(Integer createInterval) {
            this.createInterval = createInterval;
            return this;
        }

        public final Integer getRetainInterval() {
            return this.retainInterval;
        }

        public final void setRetainInterval(Integer retainInterval) {
            this.retainInterval = retainInterval;
        }

        @Override
        public final Builder retainInterval(Integer retainInterval) {
            this.retainInterval = retainInterval;
            return this;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final Boolean getExtendDeletion() {
            return this.extendDeletion;
        }

        public final void setExtendDeletion(Boolean extendDeletion) {
            this.extendDeletion = extendDeletion;
        }

        @Override
        public final Builder extendDeletion(Boolean extendDeletion) {
            this.extendDeletion = extendDeletion;
            return this;
        }

        public final List<CrossRegionCopyTarget.Builder> getCrossRegionCopyTargets() {
            List<CrossRegionCopyTarget.Builder> result = CrossRegionCopyTargetListCopier.copyToBuilder(this.crossRegionCopyTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrossRegionCopyTargets(Collection<CrossRegionCopyTarget.BuilderImpl> crossRegionCopyTargets) {
            this.crossRegionCopyTargets = CrossRegionCopyTargetListCopier.copyFromBuilder(crossRegionCopyTargets);
        }

        @Override
        public final Builder crossRegionCopyTargets(Collection<CrossRegionCopyTarget> crossRegionCopyTargets) {
            this.crossRegionCopyTargets = CrossRegionCopyTargetListCopier.copy(crossRegionCopyTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopyTargets(CrossRegionCopyTarget ... crossRegionCopyTargets) {
            this.crossRegionCopyTargets(Arrays.asList(crossRegionCopyTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionCopyTargets(Consumer<CrossRegionCopyTarget.Builder> ... crossRegionCopyTargets) {
            this.crossRegionCopyTargets(Stream.of(crossRegionCopyTargets).map(c -> (CrossRegionCopyTarget)((CrossRegionCopyTarget.Builder)CrossRegionCopyTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Exclusions.Builder getExclusions() {
            return this.exclusions != null ? this.exclusions.toBuilder() : null;
        }

        public final void setExclusions(Exclusions.BuilderImpl exclusions) {
            this.exclusions = exclusions != null ? exclusions.build() : null;
        }

        @Override
        public final Builder exclusions(Exclusions exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLifecyclePolicyRequest build() {
            return new CreateLifecyclePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DlmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLifecyclePolicyRequest> {
        public Builder executionRoleArn(String var1);

        public Builder description(String var1);

        public Builder state(String var1);

        public Builder state(SettablePolicyStateValues var1);

        public Builder policyDetails(PolicyDetails var1);

        default public Builder policyDetails(Consumer<PolicyDetails.Builder> policyDetails) {
            return this.policyDetails((PolicyDetails)((PolicyDetails.Builder)PolicyDetails.builder().applyMutation(policyDetails)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder defaultPolicy(String var1);

        public Builder defaultPolicy(DefaultPolicyTypeValues var1);

        public Builder createInterval(Integer var1);

        public Builder retainInterval(Integer var1);

        public Builder copyTags(Boolean var1);

        public Builder extendDeletion(Boolean var1);

        public Builder crossRegionCopyTargets(Collection<CrossRegionCopyTarget> var1);

        public Builder crossRegionCopyTargets(CrossRegionCopyTarget ... var1);

        public Builder crossRegionCopyTargets(Consumer<CrossRegionCopyTarget.Builder> ... var1);

        public Builder exclusions(Exclusions var1);

        default public Builder exclusions(Consumer<Exclusions.Builder> exclusions) {
            return this.exclusions((Exclusions)((Exclusions.Builder)Exclusions.builder().applyMutation(exclusions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

