/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an event that triggers an event-based policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventSource implements SdkPojo, Serializable, ToCopyableBuilder<EventSource.Builder, EventSource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(EventSource::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<EventParameters> PARAMETERS_FIELD = SdkField
            .<EventParameters> builder(MarshallingType.SDK_POJO).memberName("Parameters").getter(getter(EventSource::parameters))
            .setter(setter(Builder::parameters)).constructor(EventParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final EventParameters parameters;

    private EventSource(BuilderImpl builder) {
        this.type = builder.type;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The source of the event. Currently only managed AWS CloudWatch Events rules are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EventSourceValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The source of the event. Currently only managed AWS CloudWatch Events rules are supported.
     * @see EventSourceValues
     */
    public final EventSourceValues type() {
        return EventSourceValues.fromValue(type);
    }

    /**
     * <p>
     * The source of the event. Currently only managed AWS CloudWatch Events rules are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EventSourceValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The source of the event. Currently only managed AWS CloudWatch Events rules are supported.
     * @see EventSourceValues
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Information about the event.
     * </p>
     * 
     * @return Information about the event.
     */
    public final EventParameters parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSource)) {
            return false;
        }
        EventSource other = (EventSource) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventSource").add("Type", typeAsString()).add("Parameters", parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventSource, T> g) {
        return obj -> g.apply((EventSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventSource> {
        /**
         * <p>
         * The source of the event. Currently only managed AWS CloudWatch Events rules are supported.
         * </p>
         * 
         * @param type
         *        The source of the event. Currently only managed AWS CloudWatch Events rules are supported.
         * @see EventSourceValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceValues
         */
        Builder type(String type);

        /**
         * <p>
         * The source of the event. Currently only managed AWS CloudWatch Events rules are supported.
         * </p>
         * 
         * @param type
         *        The source of the event. Currently only managed AWS CloudWatch Events rules are supported.
         * @see EventSourceValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceValues
         */
        Builder type(EventSourceValues type);

        /**
         * <p>
         * Information about the event.
         * </p>
         * 
         * @param parameters
         *        Information about the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(EventParameters parameters);

        /**
         * <p>
         * Information about the event.
         * </p>
         * This is a convenience that creates an instance of the {@link EventParameters.Builder} avoiding the need to
         * create one manually via {@link EventParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #parameters(EventParameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link EventParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(EventParameters)
         */
        default Builder parameters(Consumer<EventParameters.Builder> parameters) {
            return parameters(EventParameters.builder().applyMutation(parameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private EventParameters parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(EventSource model) {
            type(model.type);
            parameters(model.parameters);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EventSourceValues type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final EventParameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        @Override
        public final Builder parameters(EventParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(EventParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public EventSource build() {
            return new EventSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
