/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDirectConnectGatewayAttachmentsResponse extends DirectConnectResponse
        implements
        ToCopyableBuilder<DescribeDirectConnectGatewayAttachmentsResponse.Builder, DescribeDirectConnectGatewayAttachmentsResponse> {
    private static final SdkField<List<DirectConnectGatewayAttachment>> DIRECT_CONNECT_GATEWAY_ATTACHMENTS_FIELD = SdkField
            .<List<DirectConnectGatewayAttachment>> builder(MarshallingType.LIST)
            .memberName("directConnectGatewayAttachments")
            .getter(getter(DescribeDirectConnectGatewayAttachmentsResponse::directConnectGatewayAttachments))
            .setter(setter(Builder::directConnectGatewayAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayAttachments")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DirectConnectGatewayAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(DirectConnectGatewayAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeDirectConnectGatewayAttachmentsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DIRECT_CONNECT_GATEWAY_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DirectConnectGatewayAttachment> directConnectGatewayAttachments;

    private final String nextToken;

    private DescribeDirectConnectGatewayAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayAttachments = builder.directConnectGatewayAttachments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DirectConnectGatewayAttachments
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDirectConnectGatewayAttachments() {
        return directConnectGatewayAttachments != null && !(directConnectGatewayAttachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDirectConnectGatewayAttachments}
     * method.
     * </p>
     * 
     * @return The attachments.
     */
    public final List<DirectConnectGatewayAttachment> directConnectGatewayAttachments() {
        return directConnectGatewayAttachments;
    }

    /**
     * <p>
     * The token to retrieve the next page.
     * </p>
     * 
     * @return The token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDirectConnectGatewayAttachments() ? directConnectGatewayAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectConnectGatewayAttachmentsResponse)) {
            return false;
        }
        DescribeDirectConnectGatewayAttachmentsResponse other = (DescribeDirectConnectGatewayAttachmentsResponse) obj;
        return hasDirectConnectGatewayAttachments() == other.hasDirectConnectGatewayAttachments()
                && Objects.equals(directConnectGatewayAttachments(), other.directConnectGatewayAttachments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeDirectConnectGatewayAttachmentsResponse")
                .add("DirectConnectGatewayAttachments",
                        hasDirectConnectGatewayAttachments() ? directConnectGatewayAttachments() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directConnectGatewayAttachments":
            return Optional.ofNullable(clazz.cast(directConnectGatewayAttachments()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("directConnectGatewayAttachments", DIRECT_CONNECT_GATEWAY_ATTACHMENTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectConnectGatewayAttachmentsResponse, T> g) {
        return obj -> g.apply((DescribeDirectConnectGatewayAttachmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDirectConnectGatewayAttachmentsResponse> {
        /**
         * <p>
         * The attachments.
         * </p>
         * 
         * @param directConnectGatewayAttachments
         *        The attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayAttachments(Collection<DirectConnectGatewayAttachment> directConnectGatewayAttachments);

        /**
         * <p>
         * The attachments.
         * </p>
         * 
         * @param directConnectGatewayAttachments
         *        The attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayAttachments(DirectConnectGatewayAttachment... directConnectGatewayAttachments);

        /**
         * <p>
         * The attachments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #directConnectGatewayAttachments(List<DirectConnectGatewayAttachment>)}.
         * 
         * @param directConnectGatewayAttachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directConnectGatewayAttachments(java.util.Collection<DirectConnectGatewayAttachment>)
         */
        Builder directConnectGatewayAttachments(
                Consumer<DirectConnectGatewayAttachment.Builder>... directConnectGatewayAttachments);

        /**
         * <p>
         * The token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private List<DirectConnectGatewayAttachment> directConnectGatewayAttachments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectConnectGatewayAttachmentsResponse model) {
            super(model);
            directConnectGatewayAttachments(model.directConnectGatewayAttachments);
            nextToken(model.nextToken);
        }

        public final List<DirectConnectGatewayAttachment.Builder> getDirectConnectGatewayAttachments() {
            List<DirectConnectGatewayAttachment.Builder> result = DirectConnectGatewayAttachmentListCopier
                    .copyToBuilder(this.directConnectGatewayAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDirectConnectGatewayAttachments(
                Collection<DirectConnectGatewayAttachment.BuilderImpl> directConnectGatewayAttachments) {
            this.directConnectGatewayAttachments = DirectConnectGatewayAttachmentListCopier
                    .copyFromBuilder(directConnectGatewayAttachments);
        }

        @Override
        public final Builder directConnectGatewayAttachments(
                Collection<DirectConnectGatewayAttachment> directConnectGatewayAttachments) {
            this.directConnectGatewayAttachments = DirectConnectGatewayAttachmentListCopier.copy(directConnectGatewayAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAttachments(DirectConnectGatewayAttachment... directConnectGatewayAttachments) {
            directConnectGatewayAttachments(Arrays.asList(directConnectGatewayAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAttachments(
                Consumer<DirectConnectGatewayAttachment.Builder>... directConnectGatewayAttachments) {
            directConnectGatewayAttachments(Stream.of(directConnectGatewayAttachments)
                    .map(c -> DirectConnectGatewayAttachment.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDirectConnectGatewayAttachmentsResponse build() {
            return new DescribeDirectConnectGatewayAttachmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
