/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDirectConnectGatewayAssociationProposalsResponse extends DirectConnectResponse
        implements
        ToCopyableBuilder<DescribeDirectConnectGatewayAssociationProposalsResponse.Builder, DescribeDirectConnectGatewayAssociationProposalsResponse> {
    private static final SdkField<List<DirectConnectGatewayAssociationProposal>> DIRECT_CONNECT_GATEWAY_ASSOCIATION_PROPOSALS_FIELD = SdkField
            .<List<DirectConnectGatewayAssociationProposal>> builder(MarshallingType.LIST)
            .memberName("directConnectGatewayAssociationProposals")
            .getter(getter(DescribeDirectConnectGatewayAssociationProposalsResponse::directConnectGatewayAssociationProposals))
            .setter(setter(Builder::directConnectGatewayAssociationProposals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("directConnectGatewayAssociationProposals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DirectConnectGatewayAssociationProposal> builder(MarshallingType.SDK_POJO)
                                            .constructor(DirectConnectGatewayAssociationProposal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeDirectConnectGatewayAssociationProposalsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DIRECT_CONNECT_GATEWAY_ASSOCIATION_PROPOSALS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DirectConnectGatewayAssociationProposal> directConnectGatewayAssociationProposals;

    private final String nextToken;

    private DescribeDirectConnectGatewayAssociationProposalsResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayAssociationProposals = builder.directConnectGatewayAssociationProposals;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DirectConnectGatewayAssociationProposals
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDirectConnectGatewayAssociationProposals() {
        return directConnectGatewayAssociationProposals != null
                && !(directConnectGatewayAssociationProposals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the Direct Connect gateway association proposals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasDirectConnectGatewayAssociationProposals} method.
     * </p>
     * 
     * @return Describes the Direct Connect gateway association proposals.
     */
    public final List<DirectConnectGatewayAssociationProposal> directConnectGatewayAssociationProposals() {
        return directConnectGatewayAssociationProposals;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasDirectConnectGatewayAssociationProposals() ? directConnectGatewayAssociationProposals()
                        : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectConnectGatewayAssociationProposalsResponse)) {
            return false;
        }
        DescribeDirectConnectGatewayAssociationProposalsResponse other = (DescribeDirectConnectGatewayAssociationProposalsResponse) obj;
        return hasDirectConnectGatewayAssociationProposals() == other.hasDirectConnectGatewayAssociationProposals()
                && Objects.equals(directConnectGatewayAssociationProposals(), other.directConnectGatewayAssociationProposals())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeDirectConnectGatewayAssociationProposalsResponse")
                .add("DirectConnectGatewayAssociationProposals",
                        hasDirectConnectGatewayAssociationProposals() ? directConnectGatewayAssociationProposals() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directConnectGatewayAssociationProposals":
            return Optional.ofNullable(clazz.cast(directConnectGatewayAssociationProposals()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("directConnectGatewayAssociationProposals", DIRECT_CONNECT_GATEWAY_ASSOCIATION_PROPOSALS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectConnectGatewayAssociationProposalsResponse, T> g) {
        return obj -> g.apply((DescribeDirectConnectGatewayAssociationProposalsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDirectConnectGatewayAssociationProposalsResponse> {
        /**
         * <p>
         * Describes the Direct Connect gateway association proposals.
         * </p>
         * 
         * @param directConnectGatewayAssociationProposals
         *        Describes the Direct Connect gateway association proposals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayAssociationProposals(
                Collection<DirectConnectGatewayAssociationProposal> directConnectGatewayAssociationProposals);

        /**
         * <p>
         * Describes the Direct Connect gateway association proposals.
         * </p>
         * 
         * @param directConnectGatewayAssociationProposals
         *        Describes the Direct Connect gateway association proposals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayAssociationProposals(
                DirectConnectGatewayAssociationProposal... directConnectGatewayAssociationProposals);

        /**
         * <p>
         * Describes the Direct Connect gateway association proposals.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #directConnectGatewayAssociationProposals(List<DirectConnectGatewayAssociationProposal>)}.
         * 
         * @param directConnectGatewayAssociationProposals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationProposal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directConnectGatewayAssociationProposals(java.util.Collection<DirectConnectGatewayAssociationProposal>)
         */
        Builder directConnectGatewayAssociationProposals(
                Consumer<DirectConnectGatewayAssociationProposal.Builder>... directConnectGatewayAssociationProposals);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private List<DirectConnectGatewayAssociationProposal> directConnectGatewayAssociationProposals = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectConnectGatewayAssociationProposalsResponse model) {
            super(model);
            directConnectGatewayAssociationProposals(model.directConnectGatewayAssociationProposals);
            nextToken(model.nextToken);
        }

        public final List<DirectConnectGatewayAssociationProposal.Builder> getDirectConnectGatewayAssociationProposals() {
            List<DirectConnectGatewayAssociationProposal.Builder> result = DirectConnectGatewayAssociationProposalListCopier
                    .copyToBuilder(this.directConnectGatewayAssociationProposals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDirectConnectGatewayAssociationProposals(
                Collection<DirectConnectGatewayAssociationProposal.BuilderImpl> directConnectGatewayAssociationProposals) {
            this.directConnectGatewayAssociationProposals = DirectConnectGatewayAssociationProposalListCopier
                    .copyFromBuilder(directConnectGatewayAssociationProposals);
        }

        @Override
        public final Builder directConnectGatewayAssociationProposals(
                Collection<DirectConnectGatewayAssociationProposal> directConnectGatewayAssociationProposals) {
            this.directConnectGatewayAssociationProposals = DirectConnectGatewayAssociationProposalListCopier
                    .copy(directConnectGatewayAssociationProposals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAssociationProposals(
                DirectConnectGatewayAssociationProposal... directConnectGatewayAssociationProposals) {
            directConnectGatewayAssociationProposals(Arrays.asList(directConnectGatewayAssociationProposals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAssociationProposals(
                Consumer<DirectConnectGatewayAssociationProposal.Builder>... directConnectGatewayAssociationProposals) {
            directConnectGatewayAssociationProposals(Stream.of(directConnectGatewayAssociationProposals)
                    .map(c -> DirectConnectGatewayAssociationProposal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDirectConnectGatewayAssociationProposalsResponse build() {
            return new DescribeDirectConnectGatewayAssociationProposalsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
