/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDirectConnectGatewayAssociationProposalResponse extends DirectConnectResponse
        implements
        ToCopyableBuilder<CreateDirectConnectGatewayAssociationProposalResponse.Builder, CreateDirectConnectGatewayAssociationProposalResponse> {
    private static final SdkField<DirectConnectGatewayAssociationProposal> DIRECT_CONNECT_GATEWAY_ASSOCIATION_PROPOSAL_FIELD = SdkField
            .<DirectConnectGatewayAssociationProposal> builder(MarshallingType.SDK_POJO)
            .memberName("directConnectGatewayAssociationProposal")
            .getter(getter(CreateDirectConnectGatewayAssociationProposalResponse::directConnectGatewayAssociationProposal))
            .setter(setter(Builder::directConnectGatewayAssociationProposal))
            .constructor(DirectConnectGatewayAssociationProposal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("directConnectGatewayAssociationProposal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DIRECT_CONNECT_GATEWAY_ASSOCIATION_PROPOSAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DirectConnectGatewayAssociationProposal directConnectGatewayAssociationProposal;

    private CreateDirectConnectGatewayAssociationProposalResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayAssociationProposal = builder.directConnectGatewayAssociationProposal;
    }

    /**
     * <p>
     * Information about the Direct Connect gateway proposal.
     * </p>
     * 
     * @return Information about the Direct Connect gateway proposal.
     */
    public final DirectConnectGatewayAssociationProposal directConnectGatewayAssociationProposal() {
        return directConnectGatewayAssociationProposal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayAssociationProposal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectConnectGatewayAssociationProposalResponse)) {
            return false;
        }
        CreateDirectConnectGatewayAssociationProposalResponse other = (CreateDirectConnectGatewayAssociationProposalResponse) obj;
        return Objects.equals(directConnectGatewayAssociationProposal(), other.directConnectGatewayAssociationProposal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDirectConnectGatewayAssociationProposalResponse")
                .add("DirectConnectGatewayAssociationProposal", directConnectGatewayAssociationProposal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directConnectGatewayAssociationProposal":
            return Optional.ofNullable(clazz.cast(directConnectGatewayAssociationProposal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("directConnectGatewayAssociationProposal", DIRECT_CONNECT_GATEWAY_ASSOCIATION_PROPOSAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDirectConnectGatewayAssociationProposalResponse, T> g) {
        return obj -> g.apply((CreateDirectConnectGatewayAssociationProposalResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDirectConnectGatewayAssociationProposalResponse> {
        /**
         * <p>
         * Information about the Direct Connect gateway proposal.
         * </p>
         * 
         * @param directConnectGatewayAssociationProposal
         *        Information about the Direct Connect gateway proposal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayAssociationProposal(
                DirectConnectGatewayAssociationProposal directConnectGatewayAssociationProposal);

        /**
         * <p>
         * Information about the Direct Connect gateway proposal.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DirectConnectGatewayAssociationProposal.Builder} avoiding the need to create one manually via
         * {@link DirectConnectGatewayAssociationProposal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectConnectGatewayAssociationProposal.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #directConnectGatewayAssociationProposal(DirectConnectGatewayAssociationProposal)}.
         * 
         * @param directConnectGatewayAssociationProposal
         *        a consumer that will call methods on {@link DirectConnectGatewayAssociationProposal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directConnectGatewayAssociationProposal(DirectConnectGatewayAssociationProposal)
         */
        default Builder directConnectGatewayAssociationProposal(
                Consumer<DirectConnectGatewayAssociationProposal.Builder> directConnectGatewayAssociationProposal) {
            return directConnectGatewayAssociationProposal(DirectConnectGatewayAssociationProposal.builder()
                    .applyMutation(directConnectGatewayAssociationProposal).build());
        }
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private DirectConnectGatewayAssociationProposal directConnectGatewayAssociationProposal;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectConnectGatewayAssociationProposalResponse model) {
            super(model);
            directConnectGatewayAssociationProposal(model.directConnectGatewayAssociationProposal);
        }

        public final DirectConnectGatewayAssociationProposal.Builder getDirectConnectGatewayAssociationProposal() {
            return directConnectGatewayAssociationProposal != null ? directConnectGatewayAssociationProposal.toBuilder() : null;
        }

        public final void setDirectConnectGatewayAssociationProposal(
                DirectConnectGatewayAssociationProposal.BuilderImpl directConnectGatewayAssociationProposal) {
            this.directConnectGatewayAssociationProposal = directConnectGatewayAssociationProposal != null ? directConnectGatewayAssociationProposal
                    .build() : null;
        }

        @Override
        public final Builder directConnectGatewayAssociationProposal(
                DirectConnectGatewayAssociationProposal directConnectGatewayAssociationProposal) {
            this.directConnectGatewayAssociationProposal = directConnectGatewayAssociationProposal;
            return this;
        }

        @Override
        public CreateDirectConnectGatewayAssociationProposalResponse build() {
            return new CreateDirectConnectGatewayAssociationProposalResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
