/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a BGP peer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BGPPeer implements SdkPojo, Serializable, ToCopyableBuilder<BGPPeer.Builder, BGPPeer> {
    private static final SdkField<String> BGP_PEER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bgpPeerId").getter(getter(BGPPeer::bgpPeerId)).setter(setter(Builder::bgpPeerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpPeerId").build()).build();

    private static final SdkField<Integer> ASN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("asn")
            .getter(getter(BGPPeer::asn)).setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()).build();

    private static final SdkField<String> AUTH_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authKey").getter(getter(BGPPeer::authKey)).setter(setter(Builder::authKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authKey").build()).build();

    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addressFamily").getter(getter(BGPPeer::addressFamilyAsString)).setter(setter(Builder::addressFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressFamily").build()).build();

    private static final SdkField<String> AMAZON_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("amazonAddress").getter(getter(BGPPeer::amazonAddress)).setter(setter(Builder::amazonAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonAddress").build()).build();

    private static final SdkField<String> CUSTOMER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerAddress").getter(getter(BGPPeer::customerAddress)).setter(setter(Builder::customerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAddress").build()).build();

    private static final SdkField<String> BGP_PEER_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bgpPeerState").getter(getter(BGPPeer::bgpPeerStateAsString)).setter(setter(Builder::bgpPeerState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpPeerState").build()).build();

    private static final SdkField<String> BGP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bgpStatus").getter(getter(BGPPeer::bgpStatusAsString)).setter(setter(Builder::bgpStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bgpStatus").build()).build();

    private static final SdkField<String> AWS_DEVICE_V2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsDeviceV2").getter(getter(BGPPeer::awsDeviceV2)).setter(setter(Builder::awsDeviceV2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDeviceV2").build()).build();

    private static final SdkField<String> AWS_LOGICAL_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsLogicalDeviceId").getter(getter(BGPPeer::awsLogicalDeviceId))
            .setter(setter(Builder::awsLogicalDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLogicalDeviceId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BGP_PEER_ID_FIELD, ASN_FIELD,
            AUTH_KEY_FIELD, ADDRESS_FAMILY_FIELD, AMAZON_ADDRESS_FIELD, CUSTOMER_ADDRESS_FIELD, BGP_PEER_STATE_FIELD,
            BGP_STATUS_FIELD, AWS_DEVICE_V2_FIELD, AWS_LOGICAL_DEVICE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bgpPeerId;

    private final Integer asn;

    private final String authKey;

    private final String addressFamily;

    private final String amazonAddress;

    private final String customerAddress;

    private final String bgpPeerState;

    private final String bgpStatus;

    private final String awsDeviceV2;

    private final String awsLogicalDeviceId;

    private BGPPeer(BuilderImpl builder) {
        this.bgpPeerId = builder.bgpPeerId;
        this.asn = builder.asn;
        this.authKey = builder.authKey;
        this.addressFamily = builder.addressFamily;
        this.amazonAddress = builder.amazonAddress;
        this.customerAddress = builder.customerAddress;
        this.bgpPeerState = builder.bgpPeerState;
        this.bgpStatus = builder.bgpStatus;
        this.awsDeviceV2 = builder.awsDeviceV2;
        this.awsLogicalDeviceId = builder.awsLogicalDeviceId;
    }

    /**
     * <p>
     * The ID of the BGP peer.
     * </p>
     * 
     * @return The ID of the BGP peer.
     */
    public final String bgpPeerId() {
        return bgpPeerId;
    }

    /**
     * <p>
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     * </p>
     * 
     * @return The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    public final Integer asn() {
        return asn;
    }

    /**
     * <p>
     * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun
     * lenth of 80 characters.
     * </p>
     * 
     * @return The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a
     *         maximun lenth of 80 characters.
     */
    public final String authKey() {
        return authKey;
    }

    /**
     * <p>
     * The address family for the BGP peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressFamily}
     * will return {@link AddressFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressFamilyAsString}.
     * </p>
     * 
     * @return The address family for the BGP peer.
     * @see AddressFamily
     */
    public final AddressFamily addressFamily() {
        return AddressFamily.fromValue(addressFamily);
    }

    /**
     * <p>
     * The address family for the BGP peer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressFamily}
     * will return {@link AddressFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressFamilyAsString}.
     * </p>
     * 
     * @return The address family for the BGP peer.
     * @see AddressFamily
     */
    public final String addressFamilyAsString() {
        return addressFamily;
    }

    /**
     * <p>
     * The IP address assigned to the Amazon interface.
     * </p>
     * 
     * @return The IP address assigned to the Amazon interface.
     */
    public final String amazonAddress() {
        return amazonAddress;
    }

    /**
     * <p>
     * The IP address assigned to the customer interface.
     * </p>
     * 
     * @return The IP address assigned to the customer interface.
     */
    public final String customerAddress() {
        return customerAddress;
    }

    /**
     * <p>
     * The state of the BGP peer. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>verifying</code>: The BGP peering addresses or ASN require validation before the BGP peer can be created.
     * This state applies only to public virtual interfaces.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: The BGP peer is created, and remains in this state until it is ready to be established.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: The BGP peer is ready to be established.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: The BGP peer is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: The BGP peer is deleted and cannot be established.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bgpPeerState} will
     * return {@link BGPPeerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bgpPeerStateAsString}.
     * </p>
     * 
     * @return The state of the BGP peer. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>verifying</code>: The BGP peering addresses or ASN require validation before the BGP peer can be
     *         created. This state applies only to public virtual interfaces.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: The BGP peer is created, and remains in this state until it is ready to be
     *         established.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: The BGP peer is ready to be established.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: The BGP peer is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: The BGP peer is deleted and cannot be established.
     *         </p>
     *         </li>
     * @see BGPPeerState
     */
    public final BGPPeerState bgpPeerState() {
        return BGPPeerState.fromValue(bgpPeerState);
    }

    /**
     * <p>
     * The state of the BGP peer. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>verifying</code>: The BGP peering addresses or ASN require validation before the BGP peer can be created.
     * This state applies only to public virtual interfaces.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>: The BGP peer is created, and remains in this state until it is ready to be established.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: The BGP peer is ready to be established.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: The BGP peer is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: The BGP peer is deleted and cannot be established.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bgpPeerState} will
     * return {@link BGPPeerState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bgpPeerStateAsString}.
     * </p>
     * 
     * @return The state of the BGP peer. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>verifying</code>: The BGP peering addresses or ASN require validation before the BGP peer can be
     *         created. This state applies only to public virtual interfaces.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>: The BGP peer is created, and remains in this state until it is ready to be
     *         established.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: The BGP peer is ready to be established.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: The BGP peer is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: The BGP peer is deleted and cannot be established.
     *         </p>
     *         </li>
     * @see BGPPeerState
     */
    public final String bgpPeerStateAsString() {
        return bgpPeerState;
    }

    /**
     * <p>
     * The status of the BGP peer. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>up</code>: The BGP peer is established. This state does not indicate the state of the routing function.
     * Ensure that you are receiving routes over the BGP session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: The BGP peer is down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The BGP peer status is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bgpStatus} will
     * return {@link BGPStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bgpStatusAsString}.
     * </p>
     * 
     * @return The status of the BGP peer. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>up</code>: The BGP peer is established. This state does not indicate the state of the routing
     *         function. Ensure that you are receiving routes over the BGP session.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: The BGP peer is down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The BGP peer status is not available.
     *         </p>
     *         </li>
     * @see BGPStatus
     */
    public final BGPStatus bgpStatus() {
        return BGPStatus.fromValue(bgpStatus);
    }

    /**
     * <p>
     * The status of the BGP peer. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>up</code>: The BGP peer is established. This state does not indicate the state of the routing function.
     * Ensure that you are receiving routes over the BGP session.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>down</code>: The BGP peer is down.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown</code>: The BGP peer status is not available.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bgpStatus} will
     * return {@link BGPStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bgpStatusAsString}.
     * </p>
     * 
     * @return The status of the BGP peer. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>up</code>: The BGP peer is established. This state does not indicate the state of the routing
     *         function. Ensure that you are receiving routes over the BGP session.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>down</code>: The BGP peer is down.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown</code>: The BGP peer status is not available.
     *         </p>
     *         </li>
     * @see BGPStatus
     */
    public final String bgpStatusAsString() {
        return bgpStatus;
    }

    /**
     * <p>
     * The Direct Connect endpoint that terminates the BGP peer.
     * </p>
     * 
     * @return The Direct Connect endpoint that terminates the BGP peer.
     */
    public final String awsDeviceV2() {
        return awsDeviceV2;
    }

    /**
     * <p>
     * The Direct Connect endpoint that terminates the logical connection. This device might be different than the
     * device that terminates the physical connection.
     * </p>
     * 
     * @return The Direct Connect endpoint that terminates the logical connection. This device might be different than
     *         the device that terminates the physical connection.
     */
    public final String awsLogicalDeviceId() {
        return awsLogicalDeviceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bgpPeerId());
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(authKey());
        hashCode = 31 * hashCode + Objects.hashCode(addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(amazonAddress());
        hashCode = 31 * hashCode + Objects.hashCode(customerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(bgpPeerStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bgpStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(awsDeviceV2());
        hashCode = 31 * hashCode + Objects.hashCode(awsLogicalDeviceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BGPPeer)) {
            return false;
        }
        BGPPeer other = (BGPPeer) obj;
        return Objects.equals(bgpPeerId(), other.bgpPeerId()) && Objects.equals(asn(), other.asn())
                && Objects.equals(authKey(), other.authKey())
                && Objects.equals(addressFamilyAsString(), other.addressFamilyAsString())
                && Objects.equals(amazonAddress(), other.amazonAddress())
                && Objects.equals(customerAddress(), other.customerAddress())
                && Objects.equals(bgpPeerStateAsString(), other.bgpPeerStateAsString())
                && Objects.equals(bgpStatusAsString(), other.bgpStatusAsString())
                && Objects.equals(awsDeviceV2(), other.awsDeviceV2())
                && Objects.equals(awsLogicalDeviceId(), other.awsLogicalDeviceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BGPPeer").add("BgpPeerId", bgpPeerId()).add("Asn", asn()).add("AuthKey", authKey())
                .add("AddressFamily", addressFamilyAsString()).add("AmazonAddress", amazonAddress())
                .add("CustomerAddress", customerAddress()).add("BgpPeerState", bgpPeerStateAsString())
                .add("BgpStatus", bgpStatusAsString()).add("AwsDeviceV2", awsDeviceV2())
                .add("AwsLogicalDeviceId", awsLogicalDeviceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bgpPeerId":
            return Optional.ofNullable(clazz.cast(bgpPeerId()));
        case "asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "authKey":
            return Optional.ofNullable(clazz.cast(authKey()));
        case "addressFamily":
            return Optional.ofNullable(clazz.cast(addressFamilyAsString()));
        case "amazonAddress":
            return Optional.ofNullable(clazz.cast(amazonAddress()));
        case "customerAddress":
            return Optional.ofNullable(clazz.cast(customerAddress()));
        case "bgpPeerState":
            return Optional.ofNullable(clazz.cast(bgpPeerStateAsString()));
        case "bgpStatus":
            return Optional.ofNullable(clazz.cast(bgpStatusAsString()));
        case "awsDeviceV2":
            return Optional.ofNullable(clazz.cast(awsDeviceV2()));
        case "awsLogicalDeviceId":
            return Optional.ofNullable(clazz.cast(awsLogicalDeviceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bgpPeerId", BGP_PEER_ID_FIELD);
        map.put("asn", ASN_FIELD);
        map.put("authKey", AUTH_KEY_FIELD);
        map.put("addressFamily", ADDRESS_FAMILY_FIELD);
        map.put("amazonAddress", AMAZON_ADDRESS_FIELD);
        map.put("customerAddress", CUSTOMER_ADDRESS_FIELD);
        map.put("bgpPeerState", BGP_PEER_STATE_FIELD);
        map.put("bgpStatus", BGP_STATUS_FIELD);
        map.put("awsDeviceV2", AWS_DEVICE_V2_FIELD);
        map.put("awsLogicalDeviceId", AWS_LOGICAL_DEVICE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BGPPeer, T> g) {
        return obj -> g.apply((BGPPeer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BGPPeer> {
        /**
         * <p>
         * The ID of the BGP peer.
         * </p>
         * 
         * @param bgpPeerId
         *        The ID of the BGP peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpPeerId(String bgpPeerId);

        /**
         * <p>
         * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         * </p>
         * 
         * @param asn
         *        The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(Integer asn);

        /**
         * <p>
         * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a
         * maximun lenth of 80 characters.
         * </p>
         * 
         * @param authKey
         *        The authentication key for BGP configuration. This string has a minimum length of 6 characters and and
         *        a maximun lenth of 80 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authKey(String authKey);

        /**
         * <p>
         * The address family for the BGP peer.
         * </p>
         * 
         * @param addressFamily
         *        The address family for the BGP peer.
         * @see AddressFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressFamily
         */
        Builder addressFamily(String addressFamily);

        /**
         * <p>
         * The address family for the BGP peer.
         * </p>
         * 
         * @param addressFamily
         *        The address family for the BGP peer.
         * @see AddressFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressFamily
         */
        Builder addressFamily(AddressFamily addressFamily);

        /**
         * <p>
         * The IP address assigned to the Amazon interface.
         * </p>
         * 
         * @param amazonAddress
         *        The IP address assigned to the Amazon interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonAddress(String amazonAddress);

        /**
         * <p>
         * The IP address assigned to the customer interface.
         * </p>
         * 
         * @param customerAddress
         *        The IP address assigned to the customer interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerAddress(String customerAddress);

        /**
         * <p>
         * The state of the BGP peer. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>verifying</code>: The BGP peering addresses or ASN require validation before the BGP peer can be
         * created. This state applies only to public virtual interfaces.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: The BGP peer is created, and remains in this state until it is ready to be established.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: The BGP peer is ready to be established.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: The BGP peer is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: The BGP peer is deleted and cannot be established.
         * </p>
         * </li>
         * </ul>
         * 
         * @param bgpPeerState
         *        The state of the BGP peer. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>verifying</code>: The BGP peering addresses or ASN require validation before the BGP peer can be
         *        created. This state applies only to public virtual interfaces.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: The BGP peer is created, and remains in this state until it is ready to be
         *        established.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: The BGP peer is ready to be established.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: The BGP peer is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: The BGP peer is deleted and cannot be established.
         *        </p>
         *        </li>
         * @see BGPPeerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BGPPeerState
         */
        Builder bgpPeerState(String bgpPeerState);

        /**
         * <p>
         * The state of the BGP peer. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>verifying</code>: The BGP peering addresses or ASN require validation before the BGP peer can be
         * created. This state applies only to public virtual interfaces.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>: The BGP peer is created, and remains in this state until it is ready to be established.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: The BGP peer is ready to be established.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: The BGP peer is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: The BGP peer is deleted and cannot be established.
         * </p>
         * </li>
         * </ul>
         * 
         * @param bgpPeerState
         *        The state of the BGP peer. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>verifying</code>: The BGP peering addresses or ASN require validation before the BGP peer can be
         *        created. This state applies only to public virtual interfaces.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>: The BGP peer is created, and remains in this state until it is ready to be
         *        established.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: The BGP peer is ready to be established.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: The BGP peer is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: The BGP peer is deleted and cannot be established.
         *        </p>
         *        </li>
         * @see BGPPeerState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BGPPeerState
         */
        Builder bgpPeerState(BGPPeerState bgpPeerState);

        /**
         * <p>
         * The status of the BGP peer. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>up</code>: The BGP peer is established. This state does not indicate the state of the routing function.
         * Ensure that you are receiving routes over the BGP session.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: The BGP peer is down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The BGP peer status is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param bgpStatus
         *        The status of the BGP peer. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>up</code>: The BGP peer is established. This state does not indicate the state of the routing
         *        function. Ensure that you are receiving routes over the BGP session.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: The BGP peer is down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The BGP peer status is not available.
         *        </p>
         *        </li>
         * @see BGPStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BGPStatus
         */
        Builder bgpStatus(String bgpStatus);

        /**
         * <p>
         * The status of the BGP peer. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>up</code>: The BGP peer is established. This state does not indicate the state of the routing function.
         * Ensure that you are receiving routes over the BGP session.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>down</code>: The BGP peer is down.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown</code>: The BGP peer status is not available.
         * </p>
         * </li>
         * </ul>
         * 
         * @param bgpStatus
         *        The status of the BGP peer. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>up</code>: The BGP peer is established. This state does not indicate the state of the routing
         *        function. Ensure that you are receiving routes over the BGP session.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>down</code>: The BGP peer is down.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown</code>: The BGP peer status is not available.
         *        </p>
         *        </li>
         * @see BGPStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BGPStatus
         */
        Builder bgpStatus(BGPStatus bgpStatus);

        /**
         * <p>
         * The Direct Connect endpoint that terminates the BGP peer.
         * </p>
         * 
         * @param awsDeviceV2
         *        The Direct Connect endpoint that terminates the BGP peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsDeviceV2(String awsDeviceV2);

        /**
         * <p>
         * The Direct Connect endpoint that terminates the logical connection. This device might be different than the
         * device that terminates the physical connection.
         * </p>
         * 
         * @param awsLogicalDeviceId
         *        The Direct Connect endpoint that terminates the logical connection. This device might be different
         *        than the device that terminates the physical connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLogicalDeviceId(String awsLogicalDeviceId);
    }

    static final class BuilderImpl implements Builder {
        private String bgpPeerId;

        private Integer asn;

        private String authKey;

        private String addressFamily;

        private String amazonAddress;

        private String customerAddress;

        private String bgpPeerState;

        private String bgpStatus;

        private String awsDeviceV2;

        private String awsLogicalDeviceId;

        private BuilderImpl() {
        }

        private BuilderImpl(BGPPeer model) {
            bgpPeerId(model.bgpPeerId);
            asn(model.asn);
            authKey(model.authKey);
            addressFamily(model.addressFamily);
            amazonAddress(model.amazonAddress);
            customerAddress(model.customerAddress);
            bgpPeerState(model.bgpPeerState);
            bgpStatus(model.bgpStatus);
            awsDeviceV2(model.awsDeviceV2);
            awsLogicalDeviceId(model.awsLogicalDeviceId);
        }

        public final String getBgpPeerId() {
            return bgpPeerId;
        }

        public final void setBgpPeerId(String bgpPeerId) {
            this.bgpPeerId = bgpPeerId;
        }

        @Override
        public final Builder bgpPeerId(String bgpPeerId) {
            this.bgpPeerId = bgpPeerId;
            return this;
        }

        public final Integer getAsn() {
            return asn;
        }

        public final void setAsn(Integer asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(Integer asn) {
            this.asn = asn;
            return this;
        }

        public final String getAuthKey() {
            return authKey;
        }

        public final void setAuthKey(String authKey) {
            this.authKey = authKey;
        }

        @Override
        public final Builder authKey(String authKey) {
            this.authKey = authKey;
            return this;
        }

        public final String getAddressFamily() {
            return addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final String getAmazonAddress() {
            return amazonAddress;
        }

        public final void setAmazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
        }

        @Override
        public final Builder amazonAddress(String amazonAddress) {
            this.amazonAddress = amazonAddress;
            return this;
        }

        public final String getCustomerAddress() {
            return customerAddress;
        }

        public final void setCustomerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
        }

        @Override
        public final Builder customerAddress(String customerAddress) {
            this.customerAddress = customerAddress;
            return this;
        }

        public final String getBgpPeerState() {
            return bgpPeerState;
        }

        public final void setBgpPeerState(String bgpPeerState) {
            this.bgpPeerState = bgpPeerState;
        }

        @Override
        public final Builder bgpPeerState(String bgpPeerState) {
            this.bgpPeerState = bgpPeerState;
            return this;
        }

        @Override
        public final Builder bgpPeerState(BGPPeerState bgpPeerState) {
            this.bgpPeerState(bgpPeerState == null ? null : bgpPeerState.toString());
            return this;
        }

        public final String getBgpStatus() {
            return bgpStatus;
        }

        public final void setBgpStatus(String bgpStatus) {
            this.bgpStatus = bgpStatus;
        }

        @Override
        public final Builder bgpStatus(String bgpStatus) {
            this.bgpStatus = bgpStatus;
            return this;
        }

        @Override
        public final Builder bgpStatus(BGPStatus bgpStatus) {
            this.bgpStatus(bgpStatus == null ? null : bgpStatus.toString());
            return this;
        }

        public final String getAwsDeviceV2() {
            return awsDeviceV2;
        }

        public final void setAwsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
        }

        @Override
        public final Builder awsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
            return this;
        }

        public final String getAwsLogicalDeviceId() {
            return awsLogicalDeviceId;
        }

        public final void setAwsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
        }

        @Override
        public final Builder awsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
            return this;
        }

        @Override
        public BGPPeer build() {
            return new BGPPeer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
